/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpptclextra_init.cc"
 *									  created: 22/10/95	{11:02:54 am} 
 *								  last update: 19/7/96 {7:43:39 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "CppTclHeaders.h"

#include "cpptclextra_init.h"

#include "cpx_object.h"
#include "dummy_analyser.h"
#include "info_event.h"
#include "info_socket.h"
#include "info_source_bool.h"
#include "info_file_i.h"
#include "info_file_o.h"
#include "info_gatherer.h"
#include "object_control.h"
#include "record_keeper.h"
record_keeper* _cpx_record_keeper = 0;

void cpx_lib_initialise(void);
Tcl_HashTable info_table;

void cpx_lib_initialise(void){
	// must check if already initialised since we may call this repeatedly
	static bool done = false;
	if(!done) {
		Tcl_InitHashTable(&info_table, TCL_STRING_KEYS);
		done = true;
	}
}

extern "C" Tcl_PackageInitProc Cpptclextra_Init;

extern "C" int Cpptclextra_Init(Tcl_Interp* interp) {
	return Cpptcl_PkgInit(interp, cpptclextra_declare_objects);
}

int cpptclextra_declare_objects(tcl_stream& interp) {
	
	// currently just sets up the hash table
	cpx_lib_initialise();
	if (Cpptcl_Init(interp) == TCL_ERROR) {
		return TCL_ERROR;
	}
	Tcl_PkgRequire(interp, "Cpptcl", CPPTCL_VERSION, 0);
	update_metaobject(interp, object_control::take_over);
	if(_cpx_record_keeper == 0) {
		char record_keep[] = "cpxRecording";
		tcl_args t(interp);
		t.setName(record_keep);
		_cpx_record_keeper = new record_keeper(t);
	}
	
	Cpptcl_Abstract(cpx_base,cpptcl_metaobject);

    Cpptcl_Abstract(cpx_with_info, cpx_base);
    Cpptcl_Abstract(info_base,cpx_base);
    Cpptcl_Abstract(info_observable, info_base);
    Cpptcl_Abstract(info_source, info_observable);
    Cpptcl_Abstract(info_source_bool, info_source);
    Cpptcl_Abstract(info_gatherer, info_base);
    Cpptcl_Abstract(info_triggerer, info_base);
    Cpptcl_Abstract(info_socket, info_triggerer);
    Cpptcl_Abstract(info_event, info_triggerer);
    Cpptcl_Abstract(info_file, info_base);
    Cpptcl_Abstract(info_file_i, info_file);
    Cpptcl_Abstract(info_file_o, info_file);

    Cpptcl_Abstract(cpx_with_run, cpx_with_info);
    Cpptcl_Abstract(cpx_object, cpx_with_run);
    Cpptcl_Abstract(dummy_analyser, cpx_object);

	Tcl_PkgProvide(interp,"Cpptclextra",CPPTCL_VERSION);

	return TCL_OK;
}


