/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "cpx_class.cc"
 *								   created:		1/22/95	{11:33:30 pm}
 *								   last	update:	23/7/96 {10:57:03 am}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpx_class.h"
#include <strstream.h>
#include <string.h>
#include "object_control.h"
#include "cpx_object.h"

/* 
 * Syntax is as	follows:
 *	   
 *	   cpxTYPE	  'name' in	'container'
 *	   cpxTYPE	  '+name' in 'container'
 *	   
 * The last	option grabs the name 'container' and
 * appends '.name' for the new object's name - just
 * to save on typing.
 */

int cpx_class::parse_tcl_command(tcl_args& arg){
    if (!arg)  // did they supply a name for the new object?
	{
	    tcl_ <<  get_tcl_command() << ": No arguments supplied."<< tcl_error;
	    return TCL_ERROR;
	}
    // yes, so call the make function

	eci* ii = 0;
	if (((object_control*)_global_cpptcl_metaobject)->check_command_line(newFunc, arg, 
	                                           ii,get_tcl_stream()))
		return TCL_ERROR;
	
	if (ii ==0){
	    tcl_ <<  get_tcl_command() 
	    	 << ": No creation function is known. Check your C++ code."
	    	 << tcl_error;
	    return TCL_ERROR;
	}
	
    // So we're all set to create the object:      		

    if (tcl_object* obj = (*newFunc)(ii)) {
		// Now we need to add it to it's container
		if(ii->container){
			// We know it's really an 'cpx_object'.
		    cpx_object* o = (cpx_object*) obj;
		    ii->container->add_object(o);
			o->archive_creation();
			o->archive() << endl;
		}
		// object was created. We want to return it's name
		// so we can nest creations.
		// now we delete the 'eci' wrapper
		delete ii;
		if(!arg.empty())
			if(obj->parse_configuration_values(arg) == TCL_ERROR)
				return TCL_ERROR;
/*		#ifndef TCL_DONT_CHECK_CONSTRUCTOR_ARGS
		arg >> done;
		if(arg.haveErr) {
			delete ii;
			delete obj;
			return TCL_ERROR;
		}
		#endif
*/
		tcl_ << obj->get_tcl_command() << result;		
		return TCL_OK;
    } else  {
    	// We expect the constructor to return whatever error message is appropriate.
		delete ii;
		return TCL_ERROR;
    }
    
}



