/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "cpx_object.cc"
 *								   created:		1/21/95	{7:35:43 pm}
 *								   last	update:	6/7/96 {3:16:08 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpx_object.h"
#include <string.h>
#include "CppTclExtraInclude.h"
#include "util.h"

#include "object_control.h"
#include "dummy_analyser.h"

const char * cpx_object::_type = "Object";

cpx_object::cpx_object(eci * i)
:cpx_with_run(i->args),cpx_with_container(i->container){
	// the eci was allocated by 'new' so we must get rid of it
	// (it's only there to compress 3 parameters into 1).

	// delete i;
	// seems to be causing some problems right now
	// I think I've fixed these - must check.
}

cpx_object::~cpx_object(void) {
    // delete all objects I contain
    
    // there is a slight problem in that when I delete an object,
    // it removes itself from my list, so the list has changed,...

    list_pos<cpx_with_container*> p(contents);  	
  	while(p) {
		if(cpx_object* o = ckcast(p.item(),cpx_object)){
			//cout << "Deleting:" << o->type() << (void*)o << o->name() << endl;
			delete o;
			p = contents.head();
		} else  {
			++p;
		}
  	}
  	
    	
    // have to remove quick lookup stuff
    if(quick_lookup)
    	delete [] quick_lookup;
	destroy_so_remove_me();
	
}


bool cpx_object::can_add (const char * t) const { 
    if(maycast(t,info_base)) {
		return false;
    } else if (maycast(t,dummy_analyser)) {
		return true;
    } else
		return cpx_with_run::can_add(t);
}



cpx_error cpx_object::request_event(info_socket* , info_event* ) {
    //ev->add_object(e);
	return cpx_error::OK;
}


ostream& cpx_object::write_to_stream(ostream& o) {
	return o;
}

istream& cpx_object::read_from_stream(istream& i) {
	return i;
}


cpx_error cpx_object::make_graph_of_contents(void) {
	
	return cpx_error::OK;
}

cpx_error cpx_object::make_inspector(void) {
	return cpx_error::OK;
}

void cpx_object::archive_creation(void) {
    archive() << _global_cpptcl_metaobject->command_for(type()) 
              << " " << get_tcl_command() 
              << " in " << container->get_tcl_command();
}

int cpx_object::parse_tcl_command(tcl_args& arg){
	bool used = false;
	if (cpx_with_container::parse_tcl_command(used,arg))
		return TCL_ERROR;
	else 
		if(used) return TCL_OK;
	
  	if (arg("","delete this object")=="kill") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		delete this;
		return TCL_OK;
	} else  // if we don't recognize the command, see if cpx_with_run does
		return cpx_with_run::parse_tcl_command(arg);
}







