/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpx_with_run.cc"
 *									  created: 22/6/95 {4:23:36	pm}	
 *								  last update: 26/6/96 {3:17:42 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpx_with_run.h"
#include <string.h>
#include "cpx_object.h"

const char * cpx_with_run::_type = "With Run";

cpx_with_run::cpx_with_run(tcl_args& arg)
:cpx_with_info(arg) {
}

cpx_with_run::~cpx_with_run(void){
}

cpx_error cpx_with_run::try_to_run(bool force){
	if(!ready()) {
		if(force) {
			initialise();
			run();
			return cpx_error::WARNING;
		}
		return cpx_error::ERROR;
		
	}
	initialise();
	run();
	return cpx_error::OK;		
}

bool cpx_with_run::ready(void) const   {
/*
 * We only check our non-information contents types, because an object
 * may not need all its information to be ready before it can run.
 */
	for(list_pos<cpx_with_container*> o(contents);o;++o) {
	    if(const cpx_object* obj = o.item()->is_object())
	    	if(!obj->ready())
				return false;
	}
	return true;
}


void cpx_with_run::initialise(void) {
    // This ought to be inherited by all derived classes
    for(list_pos<cpx_with_container*> p(contents);p;++p){
		if(cpx_object* o = p.item()->is_object())
			o->initialise();
	}
}

int cpx_with_run::parse_tcl_command(tcl_args& arg){
  	if (arg("","prepare this object for running")=="initialise") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
      	if(ready())
	  		initialise();
      	return TCL_OK;
  	} else if (arg("","run this object")=="run") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
  		if(1 /*argc<2*/) {
  			try_to_run();
  			return TCL_OK;
  			
			/* 
			 * if(try_to_run() != 0) {
			 *	   tcl_	<< get_tcl_command() << ": not ready to run."	<< tcl_error;
			 *	   return TCL_ERROR;
			 * }
			 */
  		} else {
  			try_to_run();
  			return TCL_OK;
			/* 
			 * if(!strcmp(argv[1],"force"))	{
			 *	   if(try_to_run(true) != 0)  {
			 *		   tcl_	<< get_tcl_command() 
			 *				<< ": warning object not ready to run."	<< result;
			 *		   return TCL_OK;
			 *	   }
			 * } else {
			 *	   tcl_	<< get_tcl_command() 
			 *			<< ": didn't understand	optional argument."	<< tcl_error;
			 *	   return TCL_ERROR;
			 * }
			 */
  		}
      	return TCL_OK;
  } else  // if we don't recognize the command, see if cpx_object does
    return cpx_with_info::parse_tcl_command(arg);
}

