/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_event.cc"
 *								   created:		1/24/95	{7:26:48 pm}
 *								   last	update:	26/6/96 {3:19:34 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "info_event.h"
#include "info_socket.h"
#include <string.h>
#include "cpx_object.h"
#include "object_control.h"

const char * info_triggerer::_type = "Info Triggerer";	

bool info_triggerer::can_add(const char* t) const{
    return(maycast(t,info_socket));
}

cpx_error info_triggerer::add_info(info_base* base) {
    if(info_socket* e = ckcast(base,info_socket)){
		archive() << get_tcl_command() << " connect " << e->get_tcl_command() << endl;
		register_socket(e);
		e->register_event(this);
		return cpx_error::OK;
    } else {
		return cpx_error::ERROR;
    }
}

cpx_error info_triggerer::remove_info(info_base* base) {
    if(info_socket* e = ckcast(base,info_socket)){
		archive() << get_tcl_command() << " disconnect " << e->get_tcl_command() << endl;
		deregister_socket(e);
		e->deregister_event(this);
		return cpx_error::OK;
    } else {
		return cpx_error::ERROR;
    }
}

bool info_triggerer::has_requests(void) const {
	return (requests.isNonEmpty());
}

void info_triggerer::trigger(void) {
    // loop over my list of requests and call them
    for(list_pos<info_socket*> scanner(requests);scanner;++scanner) {
		info_socket* call = scanner.item();
		call->call(this->container);
    }
}

void info_triggerer::trigger(cpx_with_info* substitute) {
    // loop over my list of requests and call them
    for(list_pos<info_socket*> scanner(requests);scanner;++scanner) {
		info_socket* call = scanner.item();
		call->call(substitute);
    }
}

cpx_error info_triggerer::register_socket(info_socket* e) {
    requests.append(e);
    return cpx_error::OK;
}

cpx_error info_triggerer::deregister_socket(info_socket* e) {
    requests.remove(e);
    return cpx_error::OK;
}

info_triggerer::~info_triggerer(void) {
}

info_triggerer::info_triggerer(const char* tcl_name, cpx_with_info* container)
:info_base(tcl_name, container){
}

int info_triggerer::parse_tcl_command(tcl_args& arg){	
	if (arg("","list all current sockets I trigger")=="getContents") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		// Note this could return nothing at all
		for(list_pos<info_socket*> s = requests;s;++s) {
			info_socket* call = s.item();
			tcl_ <<  call->get_tcl_command() << lappend;
		}
		return TCL_OK;
    } else if (arg("socket","attach trigger to given socket")=="connect") {
		info_socket *val;
		arg >> val >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		add_info(val);
		return TCL_OK;
    /*
		const char *val;
		arg >> val >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		cpx_base* t = getCpxBaseByName(tcl_,val);
		info_socket* test = ckcast(t,info_socket);
		if (!test){
			tcl_ <<  get_tcl_command() << ": No such object."<< tcl_error;
	    return TCL_ERROR;
		}
		add_info(test);
		return TCL_OK;
	*/
    } else if (arg("socket","detach trigger from given socket")=="disconnect") {
		const char *val;
		arg >> val >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		cpx_base* t = getCpxBaseByName(tcl_,val);
		info_socket* test = ckcast(t,info_socket);
		if (!test){
			tcl_ <<  get_tcl_command() << ": No such object."<< tcl_error;
	    return TCL_ERROR;
		}
		remove_info(test);
		return TCL_OK;
	} else  // if we don't recognize the command, see if info_base does
		return info_base::parse_tcl_command(arg);
}

const char * info_event::_type = "Info Event";	

info_event::~info_event(void) {
}

info_event::info_event(const char* tcl_name, cpx_with_info* container)
:info_triggerer(tcl_name, container)
{
	find_static_part(tcl_name);
}

s_info_base* info_event::new_static(const char* n) {
	return new s_info_event(n);
}


int info_event::parse_tcl_command(tcl_args& arg){	
	return info_triggerer::parse_tcl_command(arg);
}
