/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_file_o.cc"
 *								   created:		1/30/95	{11:26:12 am}
 *								   last	update:	26/2/96 {7:56:06 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "info_file_o.h"
#include <fstream.h>
#include "util.h"
#include <string.h>

const char * info_file_o::_type = "Output File";
cpx_type info_file_o::type(void) const  { return _type;}

info_file_o::info_file_o(const char* tcl_name, cpx_with_info* container)
	:info_file(tcl_name, container)
{

}

void info_file_o::reset_to_start(void) {
  if(_file_name) {
	//file.rdbuf()->freeze(0);
	file.rdbuf()->pubseekpos(0);
  }
}

bool info_file_o::set_file(const char* s, bool append)  {
    if(_file_name) { close_file(); }
    // we put this at the top of this function in case we are actually
    // an archive file, because we don't want to archive the specification
    // of archive file to ourselves!
    archive() << get_tcl_command() << " setFile " << s;
    if(append) archive() << " append";
    archive() << endl;
    _file_name = mystrdup(s);
    file.clear();
    file.open(_file_name, ios::out | (append ? ios::app : ios::trunc) );
    // Shouldn't need to do this, but there seems to be some problem!
    file.clear();
    // return true if ok
    return (file.good() ? true : false);
}

void info_file_o::close_file(void)  {
	if(_file_name) {
		status(0) << "Closing old file" << ends;
		file.close();
		delete _file_name;
		_file_name = 0;
	}
	archive() << get_tcl_command() << " closeFile" << endl;
}

