/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_gatherer_t.cc"
 *								   created:		1/25/95	{10:01:35 pm}
 *								   last	update:	26/6/96 {3:18:29 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#ifdef DEFINE_TEMPLATES

#include "info_gatherer.h"
#include "info_source.h"
#include "cpx_object.h"
#include <string.h>


template <class T>
info_gatherer_<T>::info_gatherer_(const char* tcl_name, cpx_with_info* container)
	:info_src_gatherer(tcl_name, container)
{
    scale_min = scale_max = (T) 0;
}

template <class T>
info_gatherer_<T>::operator T () const { 	
	info_source* s;
    if(quick_lookup != -1)
    	s = (info_source*) temp->information(_source_name,quick_lookup);
    else
		s = (info_source*) temp->information(_source_name);
	
	if(!scaled) {
	    T temp_val;
	    s->get(temp_val);
	    return temp_val;
	} else  {
	    T temp_val;
	    s->get(temp_val,scale_min, scale_max);
	    return temp_val;
	}
}

template <class T>
info_gatherer_<T>& info_gatherer_<T>::operator () (const cpx_with_info* obj) {
	temp = obj;
	return *this;
}

template <class T>
ostream& info_gatherer_<T>::write_to_stream(ostream& o) {
	T t = (*this);
    return o << (double) t;
}

template <class T>
int info_gatherer_<T>::parse_tcl_command(tcl_args& arg){	
	if (arg("","get lower data limit")=="getDataMin") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		bool a,b;
		source->hasminmax(a,b);
    	if(a) {
			T i,j;
			source->minmax(i,j);		
			tcl_ << (double) i << result;
		} else {
			tcl_ << "no limit" << result;
		}
		return TCL_OK;
	} else if (arg("","get upper data limit")=="getDataMax") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
    	bool a,b;
    	source->hasminmax(a,b);
    	if(b) {
			T i,j;
			//info_max(j,*source);
			source->minmax(i,j);		
			tcl_ << (double) j << result;
		} else {
			tcl_ << "no limit" << result;
		}
		return TCL_OK;
    } else if (arg("","get lower scaling limit")=="getScaledMin") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		tcl_ << ((double)(scale_min)) << result;
		return TCL_OK;
    } else if (arg("value","set lower scaling limit")=="setScaledMin") {
		T t;
		arg >> t >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		scale_min = t;
		archive() << get_tcl_command() << " setScaledMin " << BOOL t << endl;
		return TCL_OK;
    } else if (arg("","get upper scaling limit")=="getScaledMax") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		tcl_ << ((double)(scale_max)) << result;
		return TCL_OK;
    } else if (arg("value","set upper scaling limit")=="setScaledMax") {
		T t;
		arg >> t >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		scale_max = t;
		archive() << get_tcl_command() << " setScaledMax " << BOOL t << endl;
		return TCL_OK;
    } else  // if we don't recognize the command, see if cpx_object does
    	return info_src_gatherer::parse_tcl_command(arg);
}

template <class T>
T info_gatherer_<T>::minimum(void) {
    if(scaled) {
		return scale_min;
    } else  {
		T i,j;
		source->minmax(i,j);
		return i;
    }
}

template <class T>
T info_gatherer_<T>::maximum(void) {
    if(scaled) {
		return scale_min;
    } else  {
		T i,j;
		source->minmax(i,j);
		return j;
    }
}


// some old stuff

/*
    if(quick_ref_source){
    	if(temp->type() == quick_ref_type) {
			if(!scaled) {
			    T temp_val;
    			info_source& i = temp->*quick_ref_source;
    			i.get(temp_val);
			    return temp_val;
			} else  {
			    T temp_val;
    			info_source& i = temp->*quick_ref_source;
    			i.get(temp_val,scale_min, scale_max);
    			
			    return temp_val;
			}
    	}
    	// The object we were given isn't of the correct
    	// type so try and find it inside:
    	for(list_pos<cpx_base*> q(temp->contents);q;q++) {
    		if(q.item()->type() == quick_ref_type) {
    			cpx_object* b = cast(q.item(),cpx_object);
				if(!scaled) {
				    T temp_val;
    				info_source& i = b->*quick_ref_source;
	    			i.get(temp_val);
	    			
				    return temp_val;
				} else  {
				    T temp_val;
    				info_source& i = b->*quick_ref_source;
	    			i.get(temp_val,scale_min, scale_max);
	    			
				    return temp_val;
				}
    		}
    	}
    	// give up and go the slow way
    }
    */

#endif
