/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_observable.cc"
 *									  created: 7/31/95 {12:54:53 AM} 
 *								  last update: 5/3/96 {7:31:30 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "info_observable.h"
#include "object_control.h"
#include "info_gatherer.h"

const char * info_observable::_type = "Info Observable";	

bool info_observable::can_add(const char* t) const{
	return(maycast(t,info_gatherer));
}


info_observable::info_observable(const char* tcl_name, 
								 cpx_with_info* icontainer)
	:info_base(tcl_name,icontainer) {
	quick_lookup = -1;
}

void info_observable::set_quick_index(short val) {
	quick_lookup = val;
}

cpx_error info_observable::add_info(info_base* obj){
	// I don't care so just do the reverse
	return obj->add_info(this);
}	

cpx_error info_observable::remove_info(info_base* obj){
	// I don't care so just do the reverse
	return obj->remove_info(this);
}	

quick_ref info_observable::my_quick_ref(void){
    return ((s_info_source*)s_me)->pointer_to_me;
}
