/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_source.cc"
 *								   created:		1/24/95	{6:46:54 pm}
 *								   last	update:	26/6/96 {3:16:38 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail:  vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "info_source.h"
#include <string.h>
#include "util.h"

const char * info_source::_type = "Info Source";	
cpx_type info_source::type(void) const { return _type;}

info_source::info_source(const char* tcl_name, class cpx_with_info* icontainer)
	:info_observable(tcl_name,icontainer) {
}

int info_source::parse_tcl_command(tcl_args& arg){	
  	if (arg("","is this variable an itemised list")=="itemised") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
	  	if(is_itemised())
		    tcl_ << "true" << result;
	  	else
		    tcl_ << "false" << result;
	    return TCL_OK;
  	} else if (arg("","returns itemised list of possible values")=="items") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
      	if(is_itemised()){
		  	for(const char* i = items();*i; i += strlen(i)+1) {
		      	tcl_ << i << lappend;
		  	}
		  	return TCL_OK;
      	} else {
		  tcl_ <<  get_tcl_command() << ":I'm not itemised."<< tcl_error;
		  return TCL_ERROR;
      	}
  	} else  // if we don't recognize the command, see if info_base does
      	return info_observable::parse_tcl_command(arg);
}
