/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_bool.cc"
 *									  created: 7/26/95 {9:26:58	PM}	
 *								  last update: 26/6/96 {3:16:04 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "info_source_bool.h"
#include "info_gatherer.h"
#include <string.h>

const char * info_source_bool::_type = "Info Source Bool";

cpx_type info_source_bool::type(void) const { return _type;}

void info_source_bool::make_info_gatherer(cpx_with_info* e) {
	// this gets added into 'e' in the base constructor
    const char* new_name = mystrdup(type());
    new info_gatherer_<bool>(new_name, e);
}


void info_source_bool::hasminmax(bool& mn,bool& mx) const{
	mn = mx = false;
} 

info_source_bool::info_source_bool(const char* tcl_name
				   , cpx_with_info* icontainer
				   , quick_ref ref)
    :info_source(tcl_name, icontainer),
    info_pretender<bool>()
{
	find_static_part(tcl_name);
	((s_info_source*)s_me)->pointer_to_me = ref;
}

s_info_base* info_source_bool::new_static(const char* n){
    return new s_info_source(n);
}

void info_source_bool::conversion_error(tcl_args& arg) {
	ostrstream obuf;
	// signals both that this is a special conversion error
	// and that the caller must free the string returned.
	obuf << ends << "to a true or false value" << ends;
	arg.set_conversion_type(obuf.str());
	arg.syntax("value");
}

int info_source_bool::parse_tcl_command(tcl_args& arg){	
  	if (arg("","returns current value of this variable")=="getValue"
  	    || arg("")=="get") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
  		if(p_t == true)
			tcl_ << "true" << result;
  		else
			tcl_ << "false" << result;
    	return TCL_OK;
  	} else if ((arg("value","sets this variable to the given value")=="setValue")
	           || (arg("value")=="=")
	           || (arg("value")=="set")){
		arg >> p_t >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
	  	archive() << get_tcl_command() << " setValue " << BOOL p_t << endl;
	  	return TCL_OK;
  	} else  // if we don't recognize the command, see if info_source does
    	return info_source::parse_tcl_command(arg);
}
