/* -*-C++-*-
 * ############################################################################
 *	EvoX - evolution in	complex	systems								
 *	
 *	FILE: "object_control.cc"
 *										   created:	12/14/93 10:12:27 AM
 *									   last	update:	19/7/96 {7:22:54 pm}
 *	  by: Vince	Darley
 *			 E-mail: vince@das.harvard.edu
 *			   mail:   Divison of Applied Sciences,	Harvard	University
 *					Cambridge MA 02138
 * 
 *	See	header file	for	further	information
 * 
 * ############################################################################
 */

#include "object_control.h"
#include "basic_utils.h"
#include "tcl_class.h"
#include "cpx_class.h"
#include "cpx_object.h"
#include "object.h"

#include <string.h>
#include <strstream.h>
#include <iostream.h>

int object_control::new_object_type(tcl_stream& interp, const char* tcl_command, 
				    cpx_object_fn func, const char* type, 
				    const char* parent_name, short num_of_parents) 
{ 
	if(!find_type(type)) {
	    object* o = new object(tcl_command, func, type);
		return new_object_type(interp,o,parent_name, num_of_parents);
	} else {
		// we have it already
		return TCL_OK;
	}
	
}
	

int object_control::parse_tcl_command(tcl_args& arg){	
	if (arg("syntax '?-command tcl-command? new-type parent ?parent? ...'",
    			   "inform control of a new cpx_type")=="addObjectType") {
		// Note this could return nothing at all
		const char* tcl_com = 0;
		if(!strcmp(arg.peek(),"-command")) {
			arg >> skip >> tcl_com;
		}
		const char* obj_name;
		arg >> obj_name;
		const object* o = find_object(obj_name);
		if(!o) {
			int num_parents = 0;
			const char* parent = 0;
			ostrstream ostr;
			do {
				arg >> parent;
				ostr << parent << ends;
				num_parents++;
				parent = 0;
				arg >> optional;
			} while (!arg.empty());
			arg >> done;
			NO_EXCEPTIONS(arg,TCL_ERROR);
			int ret = new_object_type(tcl_, tcl_com, (cpx_object_fn) 0, 
									  mystrdup(obj_name), 
									  ostr.str(), num_parents);
			delete ostr.str();
			return ret;
		} else {
			arg >> done;
			NO_EXCEPTIONS(arg,TCL_ERROR);
			// already exists
			return TCL_OK;
		}
    } else  // if we don't recognize the command, see if cpx_with_info does
		return cpptcl_metaobject::parse_tcl_command(arg);
}

object_control::object_control(tcl_args& arg, cpptcl_metaobject* o)
	:cpptcl_metaobject(arg, o)
{
}

object_control::~object_control(void) {
}
	

int object_control::check_command_line(cpx_object_fn, tcl_args& arg, 
									   eci* &e, tcl_stream& tstream){
    // we know it's not the simulation, so, we need to check if it's an cpx_object,
	// if not then we don't know anything about it and return OK.
	arg("?+?name in container ?...?");
	const char* given_name;
	arg >> given_name;
	//arg -= "in";
	if(arg=="in"){
		DO_NOTHING;
	} else {
		arg.signal_error(tcl_args::Syntax);
		return TCL_ERROR;
	}
	cpx_with_info* cont;
	arg >> cont;
	NO_EXCEPTIONS(arg,TCL_ERROR);
	
    ostrstream str;
    if (given_name[0] == '+') {
		// we want to concatenate our name onto the container's
		str << cont->get_tcl_command() << ':' << given_name[1] << ends;
    } else  {
		str << given_name << ends;
    }
	    
    // There's surely a better way to do the following using 
    // just a strstream and some clever pushing in and out

    char *n = str.str();
    // Now we check whether an object with that name already exists
    while(getCpptclObjectByName(get_tcl_stream(), n)) {
		// we could just signal an error, but I'll just add a number
		// this should be a configurable option
		
	    // find how many digits are on the end
		short i = strlen(n)-1;
		for(;i>0 && n[i]>='0' && n[i] <= '9';i--)
			DO_NOTHING;
		// 'i' now points just before that
		if(i+1 == (short) strlen(n)) {
			// no digits, so add one
			// we'll start from '1'
			i = strlen(n);
			n[i] = '1';
			n[i+1] = '\0';
		} else  {      			
			long count = atol(n+i+1);
			count++;
			ostrstream str2;
			n[i+1] = '\0';
			
			str2 << n << count << ends;
			n = str2.str();
		}
    }

	e = new eci(tstream, arg, cont);
	arg.setName(n);
	return TCL_OK;
}

int declare_cpx_object(tcl_stream& interp, const char* tcl_command, 
						cpx_object_fn func, const char* type, 
						const char* parents, const char* short_name, 
						short num_of_parents) 
{
    // If there's no func it's an abstract class, so tcl shouldn't know
    // about it except for it's name, which it gets from other places
    if(func) {
		setup_for_object(interp,type,tcl_command,short_name);	
		new cpx_class(interp, tcl_command, func);
    }

    return ((object_control*)_global_cpptcl_metaobject)->new_object_type(interp, tcl_command, 
    											func,type,parents,
    											num_of_parents);
}
