/* -*-C++-*-
 * ############################################################################
 *	EvoX - evolution in	complex	systems								
 *	
 *	FILE: "record_keeper.cc"
 *										   created:	12/14/93 10:12:27 AM
 *									   last	update:	19/7/96 {7:22:54 pm}
 *	  by: Vince	Darley
 *			 E-mail: vince@das.harvard.edu
 *			   mail:   Divison of Applied Sciences,	Harvard	University
 *					Cambridge MA 02138
 * 
 *	See	header file	for	further	information
 * 
 * ############################################################################
 */

#include "record_keeper.h"
#include "tcl_class.h"
#include "cpx_class.h"
#include "cpx_object.h"
#include "object.h"

#include <string.h>
#include <strstream.h>
#include <iostream.h>


record_keeper::record_keeper(tcl_args& arg)
	:cpx_with_info(arg),
	archive_file("Archive file",this),
    error_level("Error alert level",this),
    status_level("Status alert level",this)
{
    error_level.min(-1).max(10) = 10;
    status_level.min(-1).max(10)  = 7;	
}

record_keeper::~record_keeper(void) {
}
	
ostream& record_keeper::status(short n) const {
    if(n<=status_level)
		return cout;
    else
		return null();
}

ostream& record_keeper::error(short n) const {
    if(n<=error_level)
		return cerr;
    else
		return null();
}

ostream& record_keeper::null(void) const  {
	static filebuf sb;
	static ostream nullstream(&sb);
	
	return nullstream;
}

ostream& record_keeper::archive(archive_type a) const{	
    static bool archive_on = true;
    if(a == ON){
		archive_on = true;
    } else {
		if (a == OFF) archive_on = false;
    }
	
    if(archive_on) {
		if( archive_file.ready())  {
			return (ostream&) archive_file.file;
		} else  {
			return null();
		}
    } else {
		return null();
    }
}
