/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "utemplate.cc"
 *								   created:		1/25/95	{10:03:05 pm}
 *								   last	update:	24/7/96 {6:48:47 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "CppTclExtraInclude.h"
#include "info_gatherer.h"

#define DEFINE_TEMPLATES
#include "template_utils.cc"
#include "cpptcl_args.cc"
// until we have proper RTTI
const char* GETTYPE(info_observable&);
const char* GETTYPE(info_file&);

template class cpx_pair<short>;
template class cpx_pair<float>;
template class ring<double>;

#ifndef __MWERKS__
template void swap(short&,short&);
template tcl_args& cpx_args_read(tcl_args&, info_socket*&, const char*);
template tcl_args& cpx_args_read(tcl_args&, info_event*&, const char*);
template tcl_args& cpx_args_read(tcl_args&, info_source*&, const char*);
template tcl_args& cpx_args_read(tcl_args&, info_src_gatherer*&, const char*);
template tcl_args& cpx_args_read(tcl_args&, cpx_object*&, const char*);
template tcl_args& cpx_args_read(tcl_args&, cpx_with_info*&, const char*);

template tcl_args& operator >> (tcl_args& arg, cpx_with_info*& t);
template tcl_args& operator >> (tcl_args& arg, cpx_object*& t);
template tcl_args& operator >> (tcl_args& arg, info_socket*& t);
template tcl_args& operator >> (tcl_args& arg, info_event*& t);
template tcl_args& operator >> (tcl_args& arg, info_source*& t);
template tcl_args& operator >> (tcl_args& arg, info_src_gatherer*& t);

#else
// metrowerks requires the hint!
template void swap<short>(short&,short&);

template tcl_args& cpx_args_read<cpx_with_info>(tcl_args&, cpx_with_info*&, const char*);
template tcl_args& cpx_args_read<cpx_object>(tcl_args&, cpx_object*&, const char*);
template tcl_args& cpx_args_read<info_socket>(tcl_args&, info_socket*&, const char*);
template tcl_args& cpx_args_read<info_event>(tcl_args&, info_event*&, const char*);
template tcl_args& cpx_args_read<info_source>(tcl_args&, info_source*&, const char*);
template tcl_args& cpx_args_read<info_src_gatherer>(tcl_args&, info_src_gatherer*&, const char*);

// we only need these for metrowerks, because it tries to expand my
// inline for undesired types.
template tcl_args& operator >><cpx_with_info> (tcl_args& arg, cpx_with_info*& t);
template tcl_args& operator >><cpx_object> (tcl_args& arg, cpx_object*& t);
template tcl_args& operator >><info_socket> (tcl_args& arg, info_socket*& t);
template tcl_args& operator >><info_event> (tcl_args& arg, info_event*& t);
template tcl_args& operator >><info_source> (tcl_args& arg, info_source*& t);
template tcl_args& operator >><info_src_gatherer> (tcl_args& arg, info_src_gatherer*& t);
#endif

// We do these last so the template in 'tcl_args_t.cc' doesn't interfere
// with the ones above.
// --- Currently removed in favour of specialisations which give better
// error messages.  But kept this as an example of how to do it for 
// future types.
#include "tcl_args_t.cc"
#ifndef __MWERKS__
//template tcl_args& operator >> (tcl_args&, info_observable&);
//template tcl_args& operator >> (tcl_args&, info_file&);
#else
// metrowerks requires the hint!
//template tcl_args& operator>><info_observable> (tcl_args&, info_observable&);
//template tcl_args& operator>><info_file> (tcl_args&, info_file&);
#endif

#undef DEFINE_TEMPLATES
