#include "Demoone.h"

/// It's best to use an obvious type-name
const char* Toaster::_type = "Toaster";
 
Toaster::Toaster(tcl_args& arg)
:cpx_with_info(arg),
 timeleft("Time left till done",this)
{
    timeleft.min(0.0) = 0.0;
}

void Toaster::wait(void) {
        // do something
}

int Toaster::parse_tcl_command(tcl_args& arg) {
    if(arg("#seconds","set timer on toaster")=="addTime") {
        float add;
        arg >> add >> done;
        NO_EXCEPTIONS(arg,TCL_ERROR);
        if(add <0) {
            tcl_ << "You can only increment the timer" 
                 << tcl_error;
        } else {
            timeleft += add;
            tcl_ << timeleft << result;
        }
        return tcl_;
    } else if(arg("","Wait a second")=="wait") {
        arg >> done;
        NO_EXCEPTIONS(arg,TCL_ERROR);
        if(timeleft >= 1) {
            wait();
            timeleft -= 1;
        } else {
            timeleft = 0;
        }
        tcl_ << timeleft << " seconds left" << result;
        return tcl_;
    } else {
        return cpx_with_info::parse_tcl_command(arg);
    }
}

/* 
 * You can either create Toasters directly in C++ by
 * calling the constructor (it needs a trivial argument	list
 * with	its	name), or you create a 'cpx_class' to deal with
 * it in C++.  This	happens	automatically if you register
 * with	'cpptclControl', like this:
 */

/// We need a standard Tcl init function so we can load dynamically
extern "C" Tcl_PackageInitProc Demoone_Init;
/// We also supply by C++ init function which actually does most of the work.
extern Cpptcl_PackageInitProc Demoone_Cpxinit;

/// Tcl calls this procedure when we load this package
extern "C" int Demoone_Init(Tcl_Interp* interp) {
	// Cpptcl supplies this wrapper to simplify things for you
	return Cpptcl_PkgInit(interp, Demoone_Cpxinit);
}

/// Here's the C++ package init procedure
int Demoone_Cpxinit(tcl_stream& interp) {
	// We need this package too
	if (cpptclextra_declare_objects(interp) == TCL_ERROR) {
		return TCL_ERROR;
	}
	// Complex macro which relies on the stream being called 'interp'
	// It declares a new C++ class and from what it derives.
	Cpptcl_Object(Toaster, cpx_with_info);
	// Tell Tcl about this package
	Tcl_PkgProvide(interp,"Demoone","0.1");
	#ifndef NO_ITCL
  	// Use this nice wrapper which does the following:
	// 1: Finds my package's library files, and sets the global
	//    variable 'demoone_library' to their location.  It looks in 
	//    a platform dependent way for where those files should be,
	//    and examines the given environment variable DEMOONE_LIBRARY
	//    too.  You could add as an optional extra argument a compiled
	//    in location too. e.g. On MacOS, we look for the directory
	//    'demoone0.1' is a particular place.
	//
	// 2: Sets a little Tcl evaluation to source the file 'demoone.tcl'
	//    in that location, and return any appropriate error if that
	//    failed.
	//
	// The Tcl API function it calls is only part of [incr Tcl] 2.1
	return interp.PackageLibraryInit("demoone_library", /* Tcl variable */
	                                 "DEMOONE_LIBRARY", /* Environment var */
	                                 "demoone", /* Name of package */
	                                 "demoone.tcl", /* Name of init file */
	                                 "0.1", /* Version */
	                                 "DemoOne"); /* Pretty name of package */
	#else
	/* You'll have to find the library files some other way ;-) */
	return TCL_OK;
	#endif
}
