/* 
 * This	file contains formatting information for the automatic
 * generation of html or tex documentation
 */

//@Man: Demonstration classes
//@Type: CHAPTER
/** These examples show how to use the Cpptcl and EvoX systems */

#include "CppTclExtraInclude.h"

//@Section: Demonstration classes
//@Man: 
/** 
 * Simple class	which derives from 'cpx_with_info',	this means
 * it allows the configuration of contained	information	from
 * the command line, totally automatically.
 * 
 * Information may be of the following types:
 *	   
 * info_source_var<type>  --- identical	to a standard C++ data
 * member, but interfaced with Tcl too.
 * 
 * info_source_bool	---	use	this for the boolean type.
 * 
 * info_file_i --- wraps up	an 'ifstream' inside a data	member
 * 
 * info_file_o --- wraps up	an 'ofstream' inside a data	member
 * 
 * There are a number of other options:	info_socket, info_event,
 * info_gatherer, info_matrix, ... which are not discussed here.
 */
class Toaster: public cpx_with_info {
  public:
	/// Constructor, takes argument 'tcl_args&'
	/** 
	 * The argument	wraps up all the information contained
	 * in the Tcl command line into	a stream based object
	 * for easy	extraction and configuration.
     * 	  Toaster::Toaster(tcl_args& arg)
     * 	  :cpx_with_info(arg),
     * 	   timeleft("Time left till done",this)
     * 	  {
     * 	      timeleft.min(0.0) = 0.0;
     * 	  }
	 */
    Toaster(tcl_args& arg);
	/// Destructor, currently empty
    ~Toaster(void){}
	/// The type-name of the class, for use by the Cpptclextra RTTI system.
	/** 
	 * Cpptclextra keeps a record of all object	types, their relationship
	 * in the object hierarchy,	and	creation commands; use the command
	 * 'cpptclControl' to access that database.
	 * 
	 * It's best to use an obvious type-name:
	 *     const char* Toaster::_type = "Toaster";	 
	 */
    static const char* _type;
	/// Return the object's type.  Only necessary if not an abstract class.
	/**
	 *  If not abstract declare like this (inline is fine)	 
	 *    cpx_type type(void) const { return _type; }
	 */
    cpx_type type(void) const { return _type; }
	/// Used for creation of objects from Tcl, via a corresponding cpx_class.
	/**
	 *  If not abstract we need this static function, defined as follows:
     *		static tcl_object* make_new(tcl_args& arg) {
     *	        return new Toaster(arg);
     *	    }
	 */
	static tcl_object* make_new(tcl_args& arg) {
        return new Toaster(arg);
    }
	/// Allows you to add commands to this object
	/** 
	 * Cpptclextra automatically supplies a	wide range of configuration
	 * options which you must inherit, but you will	often want to add
	 * your	own	commands (e.g. to call the 'wait' function below)
	 *
     *    int Toaster::parse_tcl_command(tcl_args& arg) {
     *        if(arg("#seconds","set timer on toaster")=="addTime") {
     *            float add;
     *            arg >> add >> done;
     *            NO_EXCEPTIONS(arg,TCL_ERROR);
     *            if(add <0) {
     *                tcl_ << "You can only increment the timer" 
     *                     << tcl_error;
     *            } else {
     *                timeleft += add;
     *                tcl_ << timeleft << result;
     *            }
     *            return tcl_;
     *        } else if(arg("","Wait a second")=="wait") {
     *            arg >> done;
     *            NO_EXCEPTIONS(arg,TCL_ERROR);
     *            if(timeleft >= 1) {
     *                wait();
     *                timeleft -= 1;
     *            } else {
     *                timeleft = 0;
     *            }
     *            tcl_ << timeleft << " seconds left" << result;
     *            return tcl_;
     *        } else {
     *            return cpx_with_info::parse_tcl_command(arg);
     *        }
     *    }
	 */
    int parse_tcl_command(tcl_args& arg);
	/// An example Tcl-C++ interfaced data member
    info_source_var<float> timeleft;
	/// A member function which will be called in Tcl with 'obj wait'
	 /**	
	  *	You	will fill in this function definition
	  *	   void	Toaster::wait(void)	{
	  *		   // do something
	  *	   }
	  */
    void wait(void);
};
/**
 *  Here's the source code for telling Cpptcl and Tcl about
 *  your new class, and for making a dynamically loadable
 *  Tcl package.
 *
 *    /* 
 *     * You can either create Toasters directly in C++ by
 *     * calling the constructor (it needs a trivial argument list
 *     * with its name), or you create a 'cpx_class' to deal with
 *     * it in C++.  This happens automatically if you register
 *     * with 'cpptclControl', like this:
 *     *     Cpptcl_Object(Toaster, cpx_with_info);
 *     *
 *
 *    /// We need a standard Tcl init function so we can load dynamically
 *    extern "C" Tcl_PackageInitProc Demoone_Init;
 *    /// We also supply by C++ init function which actually does most of the work.
 *    extern Cpptcl_PackageInitProc Demoone_Cpxinit;
 *    
 *    /// Tcl calls this procedure when we load this package
 *    extern "C" int Demoone_Init(Tcl_Interp* interp) {
 *    	// Cpptcl supplies this wrapper to simplify things for you
 *    	return Cpptcl_PkgInit(interp, Demoone_Cpxinit);
 *    }
 *    
 *    /// Here's the C++ package init procedure
 *    int Demoone_Cpxinit(tcl_stream& interp) {
 *    	// We need this package too
 *    	if (cpptclextra_declare_objects(interp) == TCL_ERROR) {
 *    		return TCL_ERROR;
 *    	}
 *    	// Complex macro which relies on the stream being called 'interp'
 *    	// It declares a new C++ class and from what it derives.
 *    	Cpptcl_Object(Toaster, cpx_with_info);
 *    	// Tell Tcl about this package
 *    	Tcl_PkgProvide(interp,"Demoone","0.1");
 *    	// Everything went ok, so return
 *    	return TCL_OK;	
 *    }
 */
/**
 * Here's the end result:
 * 
 *    % package require Demoone
 *    0.1
 *    % Toaster t
 *    t
 *    % documentObject t
 *    t addTime : set timer on toaster
 *    t areYou : am I of the given type?
 *    t canAdd : can this type be put inside me?
 *    t cget : return value of a configuration option
 *    t config : set a configuration option
 *    t configure : set a configuration option
 *    t contains : Do I directly contain this object?
 *    t doesContain : no help available.
 *    t getContents : list all things I contain
 *    t getInformation : return name of a piece of information I contain
 *    t getType : returns cpx_type of this object
 *    t ready : am I ready to run?
 *    t rename : changes the Tcl command name of the object
 *    t wait : Wait a second
 *    
 *    % contentsList t
 *    {{Time left till done} 0}
 *    % prettyContentsList t
 *    "Time left till done" 0
 *    
 *    % t
 *    No argument given to 't' should be one of: addTime, areYou, canAdd, cget, 
 *    config, configure, contains, doesContain, getContents, getInformation, 
 *    getType, ready, rename, wait
 *    % t configure
 *    t: need a configuration option and value, any of: Time_left_till_done
 *    % t configure -Time_left_till_done 5
 *    5
 *    % t wait
 *    4 seconds left
 *    % t wait
 *    3 seconds left
 *    % t addTime -1
 *    You can only increment the timer
 *    % t addTime 1
 *    4
 *    % t wait
 *    3 seconds left
 *    % t wait
 *    2 seconds left
 *    % t wait
 *    1 seconds left
 *    % t wait
 *    0 seconds left
 *    % t wait
 *    0 seconds left
 *    % 
 *    % rename t {}
 */
 
 
