## -*-Tcl-*-
 # ###################################################################
 #	Vince's	Additions -	an extension package for Tcl/Alpha
 # 
 #	FILE: "cppparse.tcl"
 #									  created: 12/5/96 {8:51:41	pm}	
 #								  last update: 27/6/96 {5:30:37 pm}	
 #	Author:	Vince Darley
 #	E-mail:	<vince@das.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 #  modified by  rev reason
 #  -------- --- --- -----------
 #  12/5/96  VMD 1.0 original
 # ###################################################################
 ##

# Currently a bit experimental, but I'd be interested in feedback.

##############################################################
#															 #
#	Parses a C++ file and generates	a new C++ class	which	 #
#	interfaces the old one to Tcl.							 #
#															 #
##############################################################

# check if we're using Alpha, and if so sort out the interface
if { ![catch { version } ] && [lindex [split [version] " " ] 0] == "Alpha" } {
	# only do this first time we're sourced
	if { ![info exists vince_usingAlpha] } {
		set vince_usingAlpha 1
	}
} else {
	set vince_usingAlpha 0
}													 
if $vince_usingAlpha {
	if { ![string length [info commands oldPuts]] } {
		rename puts oldPuts
		proc puts {a0 {a1 default} {a2 "default"}} {
			if { $a1 != "default" } {
				if { $a2 != "default" } {
					return [oldPuts $a0 $a1 $a2]
				} else {
					return [oldPuts $a0 $a1]
				}
			} else {
				message $a0
			}
		}
		rename gets oldGets
		proc gets {a1 {a2 "default"}} {
			if { $a2 != "default" && $a1 != "stdin" } {
				upvar $a2 v
				return [oldGets $a1 v]
			} else {
				upvar $a2 v
				set v [statusPrompt "answer"]
			}
		}
	}
}		

set cppp_flags(ask_for_each_class) 0
set cppp_flags(directInherit) 1
set cppp_flags(useCpptclextra) 1
set cppp_flags(parseGlobalFunctions) 0
set cppp_flags(parseClasses) 1
set cppp_flags(parseStructs) 1

proc cppp_parse_class { file } {
    global cppp_classes
    set fref [open $file r]
    set line ""
    while { ![eof $fref] } {
		set line [cppp_readline $fref]
		cppp_parse_line $line
    }
    # parsed
    set fhoutname "[file root $file]_tcl[file extension $file]"
    set fhout [open $fhoutname w]
    set fcoutname "[file root $file]_tcl.cc"
    set fcout [open $fcoutname w]
    # output tcl header
    foreach ff [list $fhout $fcout] {
		puts $ff "/* -*-C++-*-"
		puts -nonewline $ff " * Automatically generated by 'cppparse' version 0.1 on "
		#puts $ff "[uplevel \#0 date]"
		puts $ff " * cppparse written by Vince Darley: vince@das.harvard.edu"
		puts $ff " * www: <http://www.fas.harvard.edu/~darley/>"
		puts $ff " */"
		puts $ff ""
	}
	
	puts $fhout "\#ifndef _Cpptcl_[file root $file]_"
	puts $fhout "\#define _Cpptcl_[file root $file]_"
	puts $fhout ""
    foreach cl [array names cppp_classes] {
		puts "Got class $cl"
		cppp_output $fhout $fcout $cl $file $fhoutname
    }
	puts $fhout ""
    puts $fhout "\#endif"
    close $fref
    close $fhout
    close $fcout
}

proc util_yn_to_zeroone {var} {
	upvar $var m
	if { $m == "y" } { 
		set m 1
	} else {
		set m 0
	}
}

proc cppp_output {fhout fcout class basefile fhoutname} {
    global cppp_classes cppp_public_vars cppp_public_fns cppp_flags
    if ![info exists cppp_public_fns($class)] {
		set cppp_public_fns($class) [list [list $class "" void]]
	}
	foreach fn $cppp_public_fns($class) {
		set fname [string trim [lindex $fn 0]]
		if { $fname == "$class" } { 
			set constructor $fn
		}
		if { $fname == "~${class}" } { 
			set destructor $fn
		}
	}
	if ![info exists constructor] { set constructor [list $class "" void] }
	if ![info exists destructor] { set destructor [list ~$class "" void] }
	set cargs [string trim [lindex $constructor 2]]
	set directInherit 0
	if { $cargs == "" || $cargs == "void" } {
		if $cppp_flags(ask_for_each_class) {
			puts "We have a simple constructor, so can inherit"
			puts "directly.  Do you wish to do this? (y/n)"
			gets stdin directInherit
			util_yn_to_zeroone directInherit
		} else {
			set directInherit $cppp_flags(directInherit)
		}
	}
	if $cppp_flags(ask_for_each_class) {
		puts "Do you wish to make public variables available in Tcl"
		puts "and use the other features of the 'Cpptclextra' hierarchy"
		puts "or would you rather have a very basic Tcl object? (y=extra)"
		gets stdin useCpptclextra
		util_yn_to_zeroone useCpptclextra
	} else {
		set useCpptclextra $cppp_flags(useCpptclextra)
	}
	
    puts $fhout "\#include \"${basefile}\""
    if $useCpptclextra {
    	set baseclass "evox_with_info"
    	puts $fhout "\#include \"CppTclExtraInclude.h\""
    } else {	
    	set baseclass "tcl_object"
    	puts $fhout "\#include \"CppTclHeaders.h\""
    }
    puts $fhout ""
    puts -nonewline $fhout "class ${class}_tcl : "
    puts -nonewline $fhout "public ${baseclass} "
    if $directInherit {
    	puts -nonewline $fhout ", public ${class} "
    }    
  	puts $fhout "\{"
    puts $fhout "  public:"
    puts $fhout "\t${class}_tcl(tcl_args& arg);"
    puts $fhout "\t~${class}_tcl(void);"
    puts $fhout "\tstatic tcl_object* make_new(tcl_args& arg)\{"
    puts $fhout "\t\treturn new ${class}_tcl(arg);"
    puts $fhout "\t\}"
    puts $fhout "\tint parse_tcl_command(tcl_args& arg);"
    if { $useCpptclextra } {
    	puts $fhout ""
    	puts $fhout "\tconst char* _type;"
    	puts $fhout "\tcpx_type type(void) const \{ return _type;\}"
    }	
    if { $useCpptclextra || !$directInherit } {
    	puts $fhout ""
    	puts $fhout "  private:"
    }
    if {!$directInherit} {
    	puts $fhout "\t${class}* ${class}_cpp_;"
    	puts $fhout ""
    }
    if $useCpptclextra {
    	if [info exists cppp_public_vars($class)] {
    		foreach var $cppp_public_vars($class) {
    			set vtype [lindex $var 0]
    			set vname [lindex $var 1]
    			if $directInherit {
    				puts $fhout "\tinfo_source_var_ref<${vtype}> ${vname}_tcl;"
    			} else {
    				puts $fhout "\tinfo_source_var_indirect<${vtype}> ${vname}_tcl;"
    			}
    		}
    	
    	}
    }    	
    puts $fhout "\};"
    puts $fhout ""
    puts $fcout "\#include \"${fhoutname}\"\n"
    if $useCpptclextra {
    	puts $fcout "const char* ${class}_tcl::_type = \"${class}\";\n"
    }
    
    puts -nonewline $fcout "${class}_tcl::${class}_tcl(tcl_args& arg)"
	puts $fcout " :"
	puts $fcout "\t${baseclass}(arg),"
	if $directInherit {
		puts -nonewline $fcout "\t${class}()"
	} else {
		puts -nonewline $fcout "\t${class}_cpp_(0)"
	}
	if $useCpptclextra {
	    if [info exists cppp_public_vars($class)] {
			foreach var $cppp_public_vars($class) {
				set vtype [lindex $var 0]
				set vname [lindex $var 1]
				puts $fcout ","
				if $directInherit {
					puts -nonewline $fcout \
							"\t${vname}_tcl(\"${vname}\",this,${vname})"
				} else {
					puts -nonewline $fcout \
							"\t${vname}_tcl(\"${vname}\",this,${class}_cpp_,info_var_t<${class},${vtype}>(${vname}))"
				}
			}
	    }
	}
	   
    puts $fcout "\{"
	if { !$directInherit } {
		puts $fcout "\t// Create base class"
		set fnargs [lindex $constructor 2]
		cppp_read_args $fcout $fnargs "\t" "none"
		puts -nonewline $fcout "\t${class}_cpp_ = new ${class}"
		cppp_args_list $fcout $fnargs
		puts $fcout ";"
	}
    puts $fcout "\}"
    
    puts $fcout ""
    puts $fcout "int ${class}_tcl::parse_tcl_command(tcl_args& arg)\{"
    
    if [info exists cppp_public_fns($class)] {
		foreach fn $cppp_public_fns($class) {
			set fname [string trim [lindex $fn 0]]
			if { $fname == "$class" } { continue }
			if { $fname == "~${class}" } { continue }
			set fnret [string trim [lindex $fn 1]]
			set fnargs [lindex $fn 2]
			set fnsargs [cppp_parse_args $fnargs]
			puts $fcout "\tif (arg(\"${fnsargs}\",\"no help\")==\"${fname}\") \{"
			cppp_read_args $fcout $fnargs "\t\t"
			if { $fnret != "void" } {
				puts -nonewline $fcout "\t\ttcl_ << ${class}_cpp_->${fname}"
			} else {
				puts -nonewline $fcout "\t\t${class}_cpp_->${fname}"
			}
			cppp_args_list $fcout $fnargs
			if { $fnret != "void" } {
				puts $fcout " << result;"
			} else {
				puts $fcout ";"
			}
			puts $fcout "\t\treturn tcl_;"
			puts $fcout -nonewline "\t\} else "
		}
    }
    puts $fcout "\{"
    puts $fcout "\t\treturn ${baseclass}::parse_tcl_command(arg);"
    puts $fcout "\t\}"
    puts $fcout "\}"
	catch {unset cppp_public_vars}
	catch {unset cppp_public_fns}
}

proc cppp_args_list { fcout fnargs } {
	puts -nonewline $fcout "(";
	set first 1
	foreach arg $fnargs {
		set alen [llength $arg]
		set aname [string trim [lindex $arg [expr $alen -1]]]
		set atype [string trim [lrange $arg 0 [expr $alen -2]]]
		if {$first} { set first 0 } else { puts -nonewline $fcout "," }
		if { ${atype} != "" } {
			puts -nonewline $fcout "${aname}_tmp"
		}
	}
	puts -nonewline $fcout ")";
}

proc cppp_read_args {fcout fnargs indent {err TCL_ERROR} } {
	foreach arg $fnargs {
		set alen [llength $arg]
		set aname [string trim [lindex $arg [expr $alen -1]]]
		set atype [string trim [lrange $arg 0 [expr $alen -2]]]
		if { ${atype} != "" } {
			puts $fcout "${indent}${atype} ${aname}_tmp;"
			puts $fcout "${indent}arg >> ${aname}_tmp;"
		}
	}
	if { $err != "none" } {
		puts $fcout "${indent}arg >> done;"
		puts $fcout "${indent}NO_EXCEPTIONS(arg,${err});"
	}
	
}

proc cppp_parse_args {fnargs} {
	set fnsargs ""
	foreach arg $fnargs {
		set alen [llength $arg]
		set aname [string trim [lindex $arg [expr $alen -1]]]
		if { [string length $aname] && $aname != "void" } {
			append fnsargs "${aname} "
		}
	}
	return [string trim $fnsargs]
}

proc cppp_readline {fref} {
    global cppp_this cppp_classes cppp_flags

    if {[gets $fref line] == -1 || [eof $fref] } { return "" }
    #puts "read:$line"
    if {[string trim $line]==""} {
		return [cppp_readline $fref]
    }
    if [cppp_starts_with $line "//"] {
		return [cppp_readline $fref]
    }
    if [cppp_starts_with $line "/*"] {
		while {![cppp_ends_with $line "*/"]} {
			gets $fref line
		}
		return [cppp_readline $fref]
    }

    if ![info exists cppp_this] {
		# outside a class

    	# probably some constant definition
    	if [cppp_contains $line "="] {
    		return [cppp_readline $fref]
    	}    	
		if [cppp_starts_with $line "class"] {
			if $cppp_flags(parseClasses) {
				set cname [lindex [split [lindex $line 1] :] 0]
				set cppp_classes($cname) "private"
				set cppp_this $cname
				return [cppp_readline $fref]
			} else {
				while {![cppp_is $line "\};"]} {
					gets $fref line
				}
				return [cppp_readline $fref]
			}
		}
		if [cppp_starts_with $line "struct"] {
			if $cppp_flags(parseStructs) {
				set cname [lindex [split [lindex $line 1] :] 0]
				set cppp_classes($cname) "public"
				set cppp_this $cname
				return [cppp_readline $fref]
			} else {
				while {![cppp_is $line "\};"]} {
					gets $fref line
				}
				return [cppp_readline $fref]
			}
		}
		if [cppp_starts_with $line "#"] {
			return [cppp_readline $fref]
		}
		if [cppp_contains $line "("] {
			# some global function
			if $cppp_flags(parseGlobalFunctions) {
				puts "err: global fns unimplemented"
			}
			return [cppp_readline $fref]
		}
		puts "err: $line"
		return [cppp_readline $fref]
    } else {
		# inside a class 
		if [cppp_is $line "\};"] {
			unset cppp_this
			return [cppp_readline $fref]
		}
		# check for a variable/pub/priv etc.
		if ![cppp_contains $line "("] {
			# variable
			return $line
		} else {
			# function
			return $line
		}
    }
}

proc cppp_is {line str} {
    if { [string trimright $line] == ${str} } {return 1 } else { return 0 }
}

proc cppp_ends_with {line str} {
    set line [string trimright $line]
    if { [string length $line] < [string length $str] } { return 0 }
    return [expr [string last $str $line] == \
			[expr [string length $line] - [string length $str]] ? \
			1 : 0]
}

proc cppp_starts_with {line str} {
    set line [string trimleft $line]
    return [expr [string first $str $line] == 0 ? 1 : 0]
}

proc cppp_contains {line str} {
    return [expr [string first $str $line] != -1 ? 1 : 0]
}

proc cppp_parse_line {line} {
    if ![string length $line] return
    global cppp_classes cppp_this
    # pub/priv etc.
    if [cppp_ends_with $line ":"] {
		set pubpriv [string trim $line]
		set pubpriv [string trim $pubpriv ":"]
		set cppp_classes($cppp_this) $pubpriv
		return
    }
    # check for declaration of variable(s)
    if ![cppp_contains $line "("] {
    	set separated [split [string trim $line ";" ] "," ]
    	set line [lindex $separated 0]
		set inum [llength $line]
		set vname [lindex $line [expr $inum -1]]
		set vtype [string trim [lrange $line 0 [expr $inum -2]]]
		#puts "variable: \"${vname}\" of type \"${vtype}\""
		set cl $cppp_classes($cppp_this)
		global cppp_${cl}_vars
		set separated [lreplace $separated 0 0 $vname]
		foreach vname $separated {
			lappend cppp_${cl}_vars($cppp_this) \
			[list $vtype $vname]
		}
    } else {
		# it's a function
		set bracepos [string first "(" $line]
		set part1 [string range $line 0 [expr $bracepos -1]]
		set fnname [lindex $part1 [expr [llength $part1] -1]]
		set fnret [lrange $part1 0 [expr [llength $part1] -2]]
		# get the arguments
		set part2 [string range $line $bracepos end]
		set part2 [string trim $part2 "();"]
		set fnargs [split $part2 ","]
		#puts "function: \"${fnname}\" of type \"${fnret},${fnargs}\""
		set cl $cppp_classes($cppp_this)
		global cppp_${cl}_fns
		lappend cppp_${cl}_fns($cppp_this) \
				[list $fnname $fnret $fnargs]
    }

}
