## -*-Tcl-*-
 # ###################################################################
 #	CppTcl
 # 
 #	FILE: "Cpptcl.tcl"
 #									  created: 21/6/96 {10:27:14 pm} 
 #								  last update: 6/7/96 {7:18:23 pm} 
 #	Author:	Vince Darley
 #	E-mail:	<vince@das.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 # ###################################################################
 ##

package require Cpptcl

proc completion {commandLine} {
	set comp [eval cpptcl complete $commandLine]
	switch [lindex $comp 0] {
		case "Completions:" {
			set common [cpptcl maxCompletion]
			if { $common != "" } {
				insertText $common
				return ""
			} else {
				beep
				return $comp
			}
		}
		case "No" {
			beep
			return ""
		}
		case "Already" {
			beep
			return ""
		}
	}
}

proc documentObject {obj} {
	set cmds [lrange [split [cpptcl complete $obj] "\n"] 1 end]
	set doc {}
	foreach f $cmds {
		catch {eval $f -h} d
		append doc "${d}\n"
	}
	return $doc
}

