## -*-Tcl-*-
 # ###################################################################
 #	CppTclExtra
 # 
 #	FILE: "Cpptclextra.tcl"
 #									  created: 21/6/96 {10:27:14 pm} 
 #								  last update: 23/7/96 {10:29:57 am} 
 #	Author:	Vince Darley
 #	E-mail:	<vince@das.harvard.edu>
 #	  mail:	Division of	Applied	Sciences, Harvard University
 #			Oxford Street, Cambridge MA	02138, USA
 #	   www:	<http://www.fas.harvard.edu/~darley/>
 #	
 #	See	header file	for	further	information
 # ###################################################################
 ##

package require Cpptclextra

proc contentsList {object} {
	if ![cpptcl isCpptcl $object] {
		return -error "Not a Cpptcl object"
	}
	set contents {}
	foreach c [$object getContents] {
		if { ![catch "$c get"] } {
			lappend contents [list [$c getName] [$c get]]
		}
	}
	return $contents	
}

proc prettyContentsList {object} {
	set contents {}
	foreach f [contentsList $object] {
		append contents "\"[lindex $f 0]\" [lindex $f 1]\n"
	}
	return $contents
}

