/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpptcl_args.cc"
 *									  created: 24/7/96 {7:04:18	pm}	
 *								  last update: 24/7/96 {7:04:40 pm}	pm}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 * ###################################################################
 */

#ifdef DEFINE_TEMPLATES

#include "CppTcl.h"
#include "cpptcl_type.h"
#include "cpptcl_metaobject.h"

template <class T> 
tcl_args& cpx_args_read(tcl_args& arg, T*& into, const char*);

template <class T> tcl_args& operator >> (tcl_args& arg, T*& t){
	return cpx_args_read(arg, t, T::_type);
}

template <class T>
tcl_args& cpx_args_read(tcl_args& arg, T*& into, const char* type){
	arg.set_conversion_type(type);
	const char* t;
	arg.const_string_read(t);
	if(!t){
		into = 0;
	} else {
		into = ckcast(getCpxBaseByName(arg,t),T);
		if(into) {
			arg.parsed_so_far << t << " ";
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}

#endif
