/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpptcl_init.h"
 *									  created: 18/12/95	{9:12:46 pm} 
 *								  last update: 19/7/96 {8:11:58 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	18/12/95 VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_cpptcl_init_
#define _EvoX_cpptcl_init_

#include "tcl_stream.h"
//@Section: CppTcl library
///
/** 
 * -------------------------------------------------------------------------
 *   
 * "cpptcl_create_stream" --
 *  
 *  Call this function from your Package_Init() procedure with the current 
 *  interpreter as an argument, and you'll receive that same interpreter 
 *  back, packaged up inside a tcl_stream.  It is up to the caller to delete 
 *  that stream at some future time.
 *  
 *  This procedure has now been enhanced to keep a record of 
 *  tcl_streams which have been created, and if there's a repeat request
 *  to return a reference to an old stream.  This will help to conserve
 *  memory.
 *  
 * --Version--Author------------------Changes-------------------------------  
 *    1.0     <vince@das.harvard.edu> original
 * -------------------------------------------------------------------------
 */
tcl_stream& cpptcl_create_stream(Tcl_Interp*);

extern class cpptcl_metaobject* _global_cpptcl_metaobject;
typedef cpptcl_metaobject* (*cpptcl_metaobject_fn)(tcl_args&, cpptcl_metaobject*);

void update_metaobject(tcl_stream& i, cpptcl_metaobject_fn f=0);


#endif
