/* -*-C++-*-
 * ############################################################################
 *	EvoX - evolution in	complex	systems							  
 *	
 *	FILE: "cpptcl_metaobject.h"
 *										   created:	12/14/93 10:26:52 AM
 *									   last	update:	21/7/96 {11:18:39 pm}
 *	  by: Vince	Darley
 *			 E-mail: vince@das.harvard.edu
 *			   mail:   Divison of Applied Sciences,	Harvard	University
 *					Cambridge MA 02138
 * 
 *	DESCRIPTION: Mediates flow of interesting information between
 *				 the user and the different	CppTclExtra objects 
 *				 
 *	HISTORY
 *					 
 *	modified who rev reason
 *	-------- --- --- ------	
 *	12/14/93 VMD 1.0 Original
 *	1/12/94	 VMD 1.1 Created internal hierarchy	of analysis-nodes as planned
 *	16/7/94	 VMD 1.2 Now allows for multiple inheritance
 *	_/_/_
 * ############################################################################
 */

#ifndef _EvoX_cpptcl_metaobject_
#define _EvoX_cpptcl_metaobject_

#include "tcl_object.h"
#include "tcl_class.h"
#include "cpptcl_type.h"
#include "cpptcl_init.h"
class object;

//@Section: CppTcl library
///
void setup_for_object(tcl_stream& interp, const char* type,
					  const char* &tcl_command, const char* &short_name);

//@Section: CppTcl library
///
int declare_cpx_object(struct tcl_stream& interp, const char* tcl_command, 
								 new_object_fn func, const char* type, 
								 const char* parents, const char*, short num_of_parents);
//@Section: CppTcl library
///
int declare_abstract_cpx_object(struct tcl_stream& interp, const char* type, 
								 const char* parents, short num_of_parents);

//@Section: CppTcl library
///
/** 
 * -------------------------------------------------------------------------
 *	 
 * "cpptcl_metaobject"	--
 *	
 *	Important control object of	which a	single instance	'cpptclControl'
 *	exists in the Tcl interpreter.	It is created automatically	by the
 *	package	init procedure.
 *		   
 * Command Summary:
 *	   
 *	   % documentObject	cpptclControl
 *	   cpptclControl addObjectType : inform	control	of a new cpx_type
 *	   cpptclControl commandFor	: the creation command for an object of	the	given type
 *	   cpptclControl hasDescendants	: test if this cpx_type	has	further	derived	types
 *	   cpptclControl isa : tests whether one type descends from	another
 *	   cpptclControl listAncestry :	list all ancestral types
 *	   cpptclControl listParents : list	parent types
 *	   cpptclControl listTypes : list of direct	descendants
 *	   cpptclControl rename	: changes the Tcl command name of the object
 *	
 * --Version--Author------------------Changes-------------------------------  
 *	  1.0	  <vince@das.harvard.edu> original
 * -------------------------------------------------------------------------
 */
class cpptcl_metaobject: public tcl_object {
  public:
	friend tcl_args& operator >> (tcl_args& arg, const object*& into);
	friend void update_metaobject(tcl_stream& i, cpptcl_metaobject_fn f=0);
	friend int declare_cpx_object(struct tcl_stream& interp, const char* tcl_command, 
									 new_object_fn func, const char* type, 
									 const char* parents, const char*, short num_of_parents);
	friend int declare_abstract_cpx_object(struct tcl_stream& interp, const char* type, 
									 const char* parents, short num_of_parents);

  public:

	///
    bool is_of_type(const char* t1, const char* type) const;
	///
    cpx_type find_type(const char* type_name) const;
	///
    object* choose_object_type(void);
	///
    object* choose_object_type(object* parent);
	///
    int parse_tcl_command(tcl_args& arg);
	///
    const char* command_for(const char*) const;
	///
    static const char* _type;
	
  protected:
	///
    cpptcl_metaobject(tcl_args&);
	/// Makes a copy and DELETES the old version
    cpptcl_metaobject(tcl_args&, cpptcl_metaobject*);
   ~cpptcl_metaobject(void);

  protected:	  
	///
    int new_object_type(tcl_stream& interp, const char* tcl_command, 
			new_object_fn func, const char* type, 
			const char* parent_name, short num_of_parents=0);
	///
    int new_object_type(tcl_stream& interp, const char* type, 
			const char* parent_name, short num_of_parents=0);
	///
    int new_object_type(tcl_stream& interp, object* o,
			const char* parent_name, short num_of_parents=0);
	///
    object* base_object;
	///
    const object* find_object(const object* from, const char* parent_name) const;
	///
    const object* find_object(const char* parent_name) const;
	///
    bool is_of_type(const object * o, const char*) const;
	///
    void link_in_more_objects(void);
	///
    ostream& write_to_stream(ostream& o);
	///
    istream& read_from_stream(istream& i);
	///
	void list_descendants(const object* o) const;

};


#endif





