/*	-*-C++-*-
 *	###################################################################
 *	 EvoX	- evolution	in	complex systems
 *	
 *	 FILE: "cpptcl_type_t.cc"
 *												  created: 24/7/96 {3:23:03 pm} 
 *											 last	update: 24/7/96 {3:23:19 pm} 
 *	 Author:	Vince	Darley
 *	 E-mail:	<vince@das.harvard.edu>
 *		mail:	Division	of	Applied Sciences,	Harvard University
 *				Oxford Street,	Cambridge MA 02138, USA
 *		 www:	<http://www.fas.harvard.edu/~darley/>
 *	 
 *	###################################################################
 */


// This lets us read directly into any cpx type.  You'll have to
// make sure the template function is generated for each type you
// use in this way. 'T' can be cpx_object, info_event, topology, ...
// and any class you derive yourself.  Now you can do this:
// 		my_class* m;  arg >> m >> done; 
// and you can assume 'm' is a real object of type 'my_class'
// because otherwise an error will have been generated!
#ifdef __MWERKS__
template <class T> tcl_args& operator >> (tcl_args& arg, T*& t);
#else
template <class T> tcl_args& cpx_args_read(tcl_args& arg, T*& into, const char*);

template <class T> tcl_args& operator >> (tcl_args& arg, T*& t){
	return cpx_args_read(arg, t, T::_type);
}
#endif