#ifdef DEFINE_TEMPLATES

#include "list.h"

////////////////////////////////////////////////////////////////////////
///										IMPLEMENTATION of	list_node											///



template<class T>	
list_node<T>::~list_node(void) {
};


////////////////////////////////////////////////////////////////////////
///										 IMPLEMENTATION	of list												 ///

template<class T>	
void list<T>::initToNulllist() {
	headPtr	=	NULL;
	tailPtr	=	NULL;
}

template<class T>	
list<T>::list()	{
	this->initToNulllist();
}

template<class T>	
list<T>::list	(T t1) {
	this->initToNulllist();
	this->append(t1);
}

template<class T>	
list<T>::list	(T t1, T t2) {
	this->initToNulllist();
	this->append(t1);
	this->append(t2);
}

template<class T>	
list<T>::list	(T t1, T t2, T t3) {
	this->initToNulllist();
	this->append(t1);
	this->append(t2);
	this->append(t3);
}

template<class T>	
list<T>::list	(T t1, T t2, T t3, T t4) {
	this->initToNulllist();
	this->append(t1);
	this->append(t2);
	this->append(t3);
	this->append(t4);
}


template<class T>
void list<T>::reverseInPlace() {

	if (this->isEmpty()) return;

	list_node<T> *now;
	list_node<T> *temp;
 
	now	=	this->headPtr;

	while	(now !=	NULL)	{
		temp = now->next;
		now->next	=	now->prev;
		now->prev	=	temp;
		now	=	temp;
 }
			
	temp = this->headPtr;
	this->headPtr	=	this->tailPtr;
	this->tailPtr	=	temp;

}


// Creates a new list, initialized by	the	first	n	elements of	array	at.	
template<class T>
list<T>::list(T	*at, int n)	
{
	int	i;
	
	this->initToNulllist();
	for	(i=0;	i<n; i++)	{
		this->append(at[i]);
	}	
}

// Allocates a new array whose elements	are	the	elements of	the	list
// The caller	of toArray assumes responsibility	for	disposing	of the
//	 memory	obtained for the array.
// If	the	list is	empty, NULL	is returned	and	no mem is	allocated.
// If	there	are	problems allocating	mem	or accessing the list, 
//	 the function	exits	the	program.
template<class T>
T	*list<T>::toArray()	const	
{
	T	*newArray;
	int	n	=	this->length();
	 int i;							
	list_pos<T>	step = this->headConst();
	
	// If	list is	empty	then bail
	if (n	== 0)	return NULL;
	
	if (!(newArray = new T[n]))	{
		cerr <<	"list.toArray: Unable	to allocate	array	of size	"	<< n <<	"\n";
		exit(1);
	}

		// Invariant:	Elements 0..i-1	of the list	have been	inserted into	array
	for	(i=0;	i	<	n-1	;	step.goNext(), i++)	{
		 if	(step.onlist())	
			 newArray[i] = step.item();
			else {
			 cerr	<< "list.toArray:	Error	accessing	element	at list	loc	"	<< i <<	"\n";
			 exit(1);
		 }
	}

	 //	We save	inserting	the	the	last element so	that we	can	do another simple
	 //	sanity check - namely	that we	are	truly	at the last	element	of the
	 //	list.

	// Assert: elements	0..n-2 have	been added to	list & n>0 
	if (step.atTail()	&& step.onlist())
		 newArray[n-1] = step.item();
	else {
		 cerr	<< "list.toArray:	Didn't reach end of	list\n";
		 exit(1);
	}

	return newArray;
}

// Returns the length	of the list
template<class T>
int	list<T>::length()	const	{
 //	Currently, steps through whole list	to find	length
 //	Could	cache	the	length in	an extra piece member	data if	this
 //	becomes	a	big	performance	hit	-	of course	that would add complexity
 //	to every other method	that modified	the	length of	lists...
	int	len	=	0;

	for	(list_pos<T> step	=	this->headConst();
		 step.onlist();
		 len++,	step.goNext());
	
	return len;
}

// Returns the value of	the	n'th element of	the	list
template<class T>
T	list<T>::nth_element(int n)	const	{
	// we	start	at 1
	n--;
	list_pos<T>	step = this->headConst();

		for	(;step.onlist()	&& n;
		 n--,	step.goNext());
	
		return step.item();
}

// Returns the position	of 't' in	the	list,	or -1	if not there
template<class T>
int	list<T>::positionOf(const	T& t)	const	{
		int	count	=	1;
	for(list_pos<T>	p	=	this->headConst(); p.onlist();p.goNext(),	count++) {
			if ( p.here()	== t ) return	count;
	}
	return -1;
}

// through(b)
//	 Returns a list	starting at	this and going through b.
template<class T>
list<T>	list_pos<T>::through(const list_pos<T> b)	const	{
	list_pos<T>	a	=	*this;
	list<T>	templist;

 
	// Make	sure a and b are on	the	list
/*	if (!a.reallyOnlist()	|| !b.reallyOnlist())
		return templist;

	// Make	sure a is	before b
	else	if (!(a	== b)	|| !(a < b))
		return templist;
*/

	// Copy	all	elements from	a	to b into	the	new	list
	do {
		templist.append(a.item());
		a.goNext();
	}	while	(!(a==b));

	templist.append(b.item());

	// Return	the	list
	return templist;
}


template<class T>	
void list<T>::trashlist()	{
	list_node<T> *l	=	headPtr, *m;
	while	(l)	{
		m	=	l->next;
		delete l;
		l	=	m;
	}
}

template<class T>	
list<T>::~list() {
	this->trashlist(); 
}

template<class T>	
list_node<T>*	list<T>::allocNode(list_node<T>	*prev, T t,	list_node<T> *next)	{
	list_node<T> *n	=	new	list_node<T>(prev, t,	next);
	if (n	== NULL) {
		cerr <<	"could not allocate	list_node.	Shucks.\n";
		exit(1);
	}
	return n;
}

template<class T>	
void list<T>::createFirstElement(T t)	{
	if (headPtr	!= NULL	|| tailPtr !=	NULL)	{
		cerr <<	"Internal	list error:	call to	createFirstElement on	non-null list.";
		exit(1);
	}
	this->headPtr	=	this->tailPtr	=	this->allocNode(NULL,	t, NULL);
}

template<class T>	
void list<T>::append(T t)	{
	if (this->isEmpty()) {
		this->createFirstElement(t);
	}	else {
		list_node<T> *oldTail	=	this->tailPtr;		
		list_node<T> *newTail	=	this->allocNode(this->tailPtr, t,	NULL);
		oldTail->next	=	newTail;
		this->tailPtr		=	newTail;
	}
}



//----------------------------------------------------
//----------------------------------------------------
template<class T>
void list<T>::remove(T t)	{
 
	 if	(this->isEmpty())	return;	
	 
	 list_node<T>	*now = headPtr;

	 while ( (now	!= NULL) &&	(now->t	!= t)) {
		 now = now->next;
	 }
	 if	(now->t==t)	{
		 list_node<T>	*pr	=	now->prev;
		 list_node<T>	*ne	=	now->next;
		 if	(now ==	headPtr)
			 headPtr = ne;
		 else
			 pr->next	=	ne;
		 if	(now ==	tailPtr)
			 tailPtr = pr;
		 else
			 ne->prev	=	pr;
		 delete	now;
	 } else	{
		 cerr	<< "There	is no	such thing to	delete!";
	 }

 }

	 
		 

template<class T>
list_pos<T>	list<T>::head()	 {
	return list_pos<T>(	this,	 this->headPtr,	false);
}

template<class T>
list_pos<T>	list<T>::headConst() const {
	return list_pos<T>(	(list<T>*	)	this,	(list_node<T>*)this->headPtr,	true);
	// Need	to cast	away const-ness	to get this	to typecheck.
	// list_pos's	look non-const to	the	compiler;
	// we've hacked	an extra field so	that calling const functions
	// on	non-const	objects	blows	up,	but	the	compiler
	// doesn't know	that.	
}

template<class T>
list_pos<T>	list<T>::tail()	 {
	return list_pos<T>(	this,	 this->tailPtr,	false);
}

template<class T>
list_pos<T>	list<T>::tailConst() const {
	return list_pos<T>(	(list<T>*) this, (list_node<T>*) this->tailPtr,	true);
	// Need	to cast	away const-ness	to get this	to typecheck.

}

template<class T>
ostream& operator<<(ostream& o,	const	list<T>& l)	{
	o	<< "list{" ;
	for(list_node<T> *ln = l.headPtr;
			ln;
			ln=ln->next) {
		o	<< ln->t <<	(ln->next	?	"	"	:	"");
	}
	o	<< "}";
	return o;
}

template<class T>
void list<T>::copyToNullFrom(const list<T>&	l) {
	list_pos<T>	tp = this->head();
	for( list_pos<T> lp	=	l.headConst(); lp.onlist();	lp.goNext()) {
		tp.insertNext( lp.here() );
	}
}

template<class T>
list<T>::list(const	list<T>& l)	{
	this->initToNulllist();
	this->copyToNullFrom(l);
}
	
template<class T>
list<T>& list<T>::operator=(const	list<T>& l)	{
	if ( this	!= &l	)	{
		this->trashlist();
		this->initToNulllist();
		this->copyToNullFrom(l);
	}
	return *this;
}

template<class T>
list<T>	list<T>::operator+(const list<T>&	lt)	const	{
	list<T>	newThis	=	*this;
	list<T>	newLT		=	lt;
	newThis.appendAndDestroy(newLT);
	return newThis;
	}

template<class T>
void list<T>::appendAndDestroy(list<T>&	lt)	{
	if(lt.isEmpty()) return;
	if(this->isEmpty())	{
		this->headPtr	=	lt.headPtr;
		this->tailPtr	=	lt.tailPtr;
		lt.headPtr		=	NULL;
		lt.tailPtr		=	NULL;
	}	else {
		list_node<T> *thisTail = this->tailPtr;
		list_node<T> *ltHead	 =	 lt.headPtr;
		thisTail->next = ltHead;
		ltHead->prev	 = thisTail;
		this->tailPtr	 = lt.tailPtr;
		lt.headPtr		=	NULL;
		lt.tailPtr		=	NULL;
	}
}

template<class T>
bool list<T>::contains(const T& t) const {
	for(list_pos<T>	p = this->headConst(); p.onlist(); p.goNext()) {
		if ( p.here() == t ) return true;
	}
	return false;
}

////////////////////////////////////////////////////////////////////////
//							IMPLEMENTATION of	list_pos														 //

template <class	T>
list_pos<T>::~list_pos(void) {
}

// added VMD 31st	Jan	1995
template<class T>
list_pos<T>::list_pos(list<T>& l)	 {
	this->cursor = l.headPtr;
	this->tolist = &l;
	this->isConstPos = false;
}

template<class T>
list_pos<T>::list_pos(const	list<T>& l)	 {
	this->cursor = l.headPtr;
	this->tolist = (list<T>*)	&l;
	this->isConstPos = true;

}

template<class T>
list_pos<T>::list_pos(list<T>	*l,	list_node<T> * n,	bool consty) {
	this->cursor = n;
	this->tolist = l;
	this->isConstPos = consty;
}

template<class T>
list_pos<T>::list_pos(const	list_pos<T>& lp) {
	this->cursor = lp.cursor;
	this->tolist = lp.tolist;
	this->isConstPos = lp.isConstPos;
}

template<class T>
list_pos<T>& list_pos<T>::operator=(const	list_pos<T>	&lp) {
	if (this !=	&lp) {
		this->cursor = lp.cursor;
		this->tolist = lp.tolist;
		this->isConstPos = lp.isConstPos;
	}
	return *this;
}

//*******************************************************
template<class T>
bool list_pos<T>::operator<(const	list_pos<T>& b)	const	{
	list_pos<T>	step = *this;

	if ((b.reallyOnlist()	&& (this->reallyOnlist())))	{
	while	(step.onlist())	{
		step.goNext();
		if (step.cursor	== b.cursor) {
			return true;
		}
	}
	}
	return false;
}

template<class T>
bool list_pos<T>::operator==(const list_pos<T>&	b) const {

/*
	 cout	<< "Testing	lp equals\n";

	 cout	<< this->cursor	<< "	$	 " <<	b.cursor <<	"\n";	
*/
	 return	(this->cursor	== b.cursor ? true : false);	
}


template<class T>
T	list_pos<T>::here()	const	{
	if (this->offlist()) {
		cerr <<	"Attempt to	look past	the	end	of a list\n";
		exit(1);
	}
	return this->cursor->t;
}

template<class T>
void list_pos<T>::insertNext(T t)	{
	if ( this->isConst() ) {
		cerr <<	"Attempt to	insert into	a	const	list.\n";
		exit(1);
	}	
	if ( this->mylist()->isEmpty() ) {
		this->mylist()->createFirstElement(t);
		this->cursor = this->mylist()->headPtr;
		return;
	}	else if	(	this->offlist()) {
		cerr <<	"Attempt to	insert past	the	end	of a list\n";
		exit(1);
	}	else {
		list_node<T> *oldPrev	=	this->cursor;
		list_node<T> *oldNext	=	this->cursor->next;
		list_node<T> *newNode	=	this->mylist()->allocNode(oldPrev, t,	oldNext);
		oldPrev->next	=	newNode;
		if(oldNext)	oldNext->prev	=	newNode;
		if(oldPrev ==	this->mylist()->tailPtr) this->mylist()->tailPtr = newNode;
		cursor = newNode;
	}
}

template<class T>
void list_pos<T>::insertPrev(T t)	{
	if ( this->isConst() ) {
		cerr <<	"Attempt to	insert into	a	const	list.\n";
		exit(1);
	}
	if (this->mylist()->isEmpty()	)	{
		this->mylist()->createFirstElement(t);
		this->cursor = this->mylist()->tailPtr;
	}	else if	(this->offlist())	{
		cerr <<	"Attempt to	insert past	the	end	of a list\n";
		exit(1);
	}	else {
		list_node<T> *oldPrev	=	this->cursor->prev;
		list_node<T> *oldNext	=	this->cursor;
		list_node<T> *newNode	=	this->mylist()->allocNode(oldPrev, t,	oldNext);
		oldNext->prev	=	newNode;
		if(oldPrev)	oldPrev->next	=	newNode;
		if(oldNext ==	this->mylist()->headPtr) this->mylist()->headPtr = newNode;
		cursor = newNode;
	}
}



template<class T>
bool list_pos<T>::atHead() const {
	return (this->mylist()->headPtr	== this->cursor	?	true : false);
}

template<class T>
bool list_pos<T>::atTail() const {
		return (this->mylist()->tailPtr	== this->cursor	?	true : false);
}

template<class T>
void list_pos<T>::goNext(){
	if (this->onlist())	this->cursor = this->cursor->next;
}

template<class T>
void list_pos<T>::goPrev(){
	if (this->onlist())	this->cursor = this->cursor->prev;
}

// Returns 1 if	the	list_pos is	actually on	the	list it	thinks it	is.
template <class	T>
bool list_pos<T>::reallyOnlist() const {
	list_pos<T>	b	=	this->mylist()->headConst();


	if (!this->onlist()) return	false;

	while	(b.onlist()) {
		if (b	== *this)	{
			return true;
		}
		b.goNext();
	}

	return false;
}

template<class T>
void list_pos<T>::delete0()	{
	if (this->offlist()	|| this->isConstPos) 
		return;
	list_node<T> * pre = this->cursor->prev;
	list_node<T> * nex = this->cursor->next;
	if (this->mylist()->headPtr	== this->cursor) {
	 	// Deleting	first	element	of list...
			this->mylist()->headPtr	=	nex;
	}	else {
			pre->next	=	nex;
	}
	if (this->mylist()->tailPtr	== this->cursor) {
			// Deleting	last element of	list.
			// Note	that we	might	also be	deleting the first (=only) element too...
			this->mylist()->tailPtr	=	pre;
	}	else {
			nex->prev	=	pre;
	}
	
	delete this->cursor;
	this->cursor = NULL;
}

template<class T>
void list_pos<T>::deleteAndGoNext()	{
		list_pos<T>	n	=	*this;
		n.goNext();
		this->delete0();
		*this	=	n;
}

template<class T>
void list_pos<T>::replaceWith(T	t) {
		if (this->offlist()	|| this->isConstPos) {
			cerr <<	"Cannot	replace	list element";
			exit(1);
		}
		this->cursor->t	=	t;
}

////////////////////////////////////////////////////////////////////////

#endif
