/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "tcl_args_t.cc"
 *									  created: 29/4/96 {4:54:30	pm}	
 *								  last update: 29/4/96 {6:40:37 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Template Definitions:   See	header file	for	further	information
 * ###################################################################
 */

#ifdef DEFINE_TEMPLATES

#include "tcl_args.h"
// to be replaced by RTTI eventually.
const char* GETTYPE(short&);
const char* GETTYPE(bool&);
const char* GETTYPE(long&);
const char* GETTYPE(float&);
const char* GETTYPE(double&);
const char* GETTYPE(char&);

template <class T> tcl_args& operator>> (tcl_args& arg, T& into);

template <class T> tcl_args& operator>> (tcl_args& arg, T& into){
	arg.set_conversion_type(GETTYPE(into));
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> into;
		arg.check_after();
		arg.parsed_so_far << into << " ";
		arg.read_done();
	}
	
	return arg;
}

#endif

