/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "tcl_class.h"
 *								   created:		1/23/95	{8:38:27 pm}
 *								   last	update:	5/7/96 {11:02:05 am}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: A class for tcl/C++ interfacing
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/23/95	  VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_tcl_class_
#define _EvoX_tcl_class_

#include "tcl_object.icc"
#include "CppTcl.h"

//@Section: CppTcl library
//@Man:
/**
 * -------------------------------------------------------------------------
 *   
 * "class tcl_class" --
 *  
 *  This is a derived class of tcl_object.  A tcl_class is a tcl_object used 
 *  to create other tcl_objects.  In other words, we might create a 
 *  tcl_class bound to the tcl command "Card" which creates new tcl_objects 
 *  bound to commands like "QueenOfHearts".  Thus, a tcl_class has only one 
 *  response to being invoked from tcl: the creation of a new tcl_object.
 *  So if you want to allow the creation of many copies of a particular
 *  C++ object in Tcl, create an associated tcl_class with:
 *
 *     new tcl_class(i,"Card",card::make_new);
 *
 *  It works by storing a pointer to a static member function of the 
 *  tcl_object to be created.  When the tcl_class procedure is invoked, it 
 *  passes on its arguments to this "make function" of the tcl_object, and 
 *  this function should then create a new instance of the tcl_object.
 *
 *  tcl_class must be instantiated from C++.  The associated tcl_object's 
 *  can then be instantiated from tcl via the tcl_class.
 *
 *  If you only want a single copy of a C++ object to exist, then just
 *  derive it from tcl_object and create it in C++.  See the object
 *  'cpptcl_control' for an example of this.
 *  
 * --Version--Author------------------Changes-------------------------------  
 *    1.0     <vince@das.harvard.edu> original
 * -------------------------------------------------------------------------
 */
class tcl_class : public tcl_object {
  public:

	/// Constructor
	/** 
	 * We need to know:
	 *	 . our interpreter, 
	 *	 . the name of the tcl command to bind to,
	 *	 . a pointer to the creation function to use.
	 */  
  	tcl_class(tcl_stream& i, const char* name, new_object_fn func) :
          		tcl_object(i, name), newFunc(func) {};

	/// Called when we are invoked; passes arg on to the make function.
  	int parse_tcl_command(tcl_args& arg);

  protected:

	/// store a pointer to the creation function.
  	new_object_fn newFunc;
};

#endif /*_EvoX_tcl_class_*/
