/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "vstreams.h"
 *									  created: 16/4/96 {2:08:30	pm}	
 *								  last update: 1/5/96 {1:12:19 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	16/4/96	 VMD 1.0 original
 * ###################################################################
 */

#ifndef __MWERKS__
#include <strstream.h>
#else
#ifndef _EvoX_vstreams_
#define _EvoX_vstreams_

/*
 *      Function:  Provide explicit implementation for CW8 strstream class
 *      which is lacking in this release
 */
#include <iostream.h>
#include <strstream.h>
//---------------------------------------------------------
class strstreambase :  public virtual ios {
  public:
	strstreambuf * rdbuf();

  protected:
	strstreambase(char  *, int, char  *);
	strstreambase();
	~strstreambase() {}
  private:
	strstreambuf buf;
};
inline strstreambuf * strstreambase::rdbuf(){ return &this->buf; }
//---------------------------------------------------------
class  iostream : public istream, public ostream {
  public:
	iostream(streambuf  *);
	virtual  ~iostream() {}
	
  protected:
	iostream();
};

//---------------------------------------------------------
class strstream : public strstreambase, public iostream {
  public:
	strstream();
	strstream(         char *, int _sz, int _m);
	strstream(signed   char *, int _sz, int _m);
	strstream(unsigned char *, int _sz, int _m);
	~strstream() {}

	char  *  str();
};
inline char  * strstream::str(){ return strstreambase::rdbuf()->str(); }


#endif

#endif
