/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "template.cc"
 *								   created:		1/25/95	{10:03:05 pm}
 *								   last	update:	19/7/96 {8:17:50 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpptcl_metaobject.h"

#define DEFINE_TEMPLATES
#include "list.cc"

class object;

template class list<object*>;
template class list_pos<object*>;
template class list_node<object*>;
template class list<const char*>;
template class list_pos<const char*>;
template class list_node<const char*>;

#undef DEFINE_TEMPLATES

tcl_args& operator>> (tcl_args& arg, const object*& into){
	// we pretend it's a type, since that's what we read
	// from the command line, although in fact we find an
	// 'object' straightaway.
	arg.set_conversion_type("cpx_type");
	const char* t;
	arg.const_string_read(t);
	if(!t){
		(void)into;
	} else {
		into = _global_cpptcl_metaobject->find_object(t);
		if(into) {
			arg.parsed_so_far << t << " ";
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}

tcl_args& operator>> (tcl_args& arg, cpx_type& into){
	arg.set_conversion_type("cpx_type");
	const char* t;
	arg.const_string_read(t);
	if(!t){
		into = 0;
	} else {
		into = _global_cpptcl_metaobject->find_type(t);	
		if(into) {
			arg.parsed_so_far << t << " ";
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}
