/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "tcl_class.cc"
 *								   created:		1/22/95	{11:33:30 pm}
 *								   last	update:	10/12/96 {1:49:12 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "tcl_class.h"
#include <strstream.h>
#include <string.h>

int tcl_class::parse_tcl_command(tcl_args& arg){
    // In case the user wishes to rename, we do that now:
	// This has the side-effect of disallowing any object
	// called "rename".
	if (arg.peek_is("rename"))
		return tcl_object::parse_tcl_command(arg);
	
	if(arg("?construction arguments? ?configuration options?",
		   "make an object").match_into(arg.tmp_chars,"'name_of_new_object'")) {
		// To investigate: remove this line and let command completion
		// extend into the innards of object creation.
		if(arg.haveErr)
			return TCL_ERROR;
		arg.setName(arg.tmp_chars);
		// yes, so call the make function	
		if (tcl_object* o = (*newFunc)(arg)){
			// check if construction argument handling went wrong
			if(arg.haveErr) {
				delete o;
				// not 100% sure we want this line
				arg >> done;
				return TCL_ERROR;
			}
			if(arg.empty()) {
				arg >> done;
				if(arg.haveErr) {
					delete o;
					return TCL_ERROR;
				}
			} else {
				if(o->parse_configuration_values(arg) == TCL_ERROR)
					return TCL_ERROR;
			}
			tcl_ << o->get_tcl_command() << result;
			return tcl_;
		} else {
			// We expect the constructor to return whatever 
			// error message is appropriate, or signal an
			// exception if they're supported.
			return TCL_ERROR;
		}
	} else {
		return tcl_object::parse_tcl_command(arg);
	}	
    
}

