/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "tcl_object.cc"
 *									  created: 11/7/95 {4:44:17	pm}	
 *								  last update: 21/6/96 {12:38:19 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "tcl_object.icc"
#include <string.h>

tcl_object* getCpptclObjectByName(tcl_stream& i, const char* name);

//extern "C"
int Tcl_ParseObjectCommand(ClientData clientData, Tcl_Interp* interp,
                           int argc, char* argv[]){
  	// verify that this command was called on the same interpreter clientData
  	// was created on

	tcl_object* o = (tcl_object*)clientData;
  	if (interp != o->get_interp()){
    	Tcl_AppendResult(interp, argv[0],
                     ": Object called from wrong interpreter!!",NULL);
    	return TCL_ERROR;
  	} else {
		// Check the object's command hasn't changed (via 'rename')
		if (strcmp(o->get_tcl_command(),argv[0]))  {
			o->change_name_to(argv[0]);
		}
      	// pass the command on to the object, without its name (since the object
      	// knows its own name)
		#ifdef NO_EXCEPTION_HANDLING      	
		tcl_args t(o->get_tcl_stream(),argc -1, argv +1,o);
		return o->parse_tcl_command(t);
		#else
		try {
			tcl_args t(o->get_tcl_stream(),argc -1, argv +1,o);
			return o->parse_tcl_command(t);
		} catch (int err) {
			// the error message is stored in the tcl interpreter
			if(err == TCL_ERROR) {
		        return err;
		    } else {
		    	o->get_tcl_stream() << "Unknown exception thrown" << append;
		    	return TCL_ERROR;
		    }
		}
		#endif
  	}
  
}

//extern "C"
void Tcl_DeleteObject(ClientData clientData){
	// this may be called either from tcl or from ~tcl_object indirectly
  	delete (tcl_object*) clientData;
}

//virtual
tcl_object::~tcl_object(void){
  	if(tcl_command) {
  		char* name = tcl_command;
  		tcl_command = 0;
  		Tcl_DeleteCommand(get_interp(), (char*) name);
  		delete name;
  	}
  
}

//virtual
int tcl_object::parse_tcl_command(tcl_args& arg){
	if (arg("newName","changes the Tcl command name of the object")=="rename") {
  		const char* newName;
  		arg >> newName >> done;
  		NO_EXCEPTIONS(arg,TCL_ERROR);
      	tcl_ << "rename " << tcl_command << " " << newName << eval;
		if(tcl_.status() == TCL_OK) {
			tcl_.ResetResult();
			change_name_to(newName);
		} 
		return tcl_;
  	} else {
  		return arg.no_match();
  	}
}

void tcl_object::change_name_to(const char* newname) {
	delete tcl_command;
	tcl_command = mystrdup(newname);
}

tcl_object* getCpptclObjectByName(tcl_stream& i, const char* name){
  	Tcl_CmdInfo info;
  	if (!Tcl_GetCommandInfo(i.interpreter(), (char*) name, &info))
    	return (tcl_object*) NULL;
  	else
    	return (tcl_object*) (info.clientData);
}

tcl_args& operator>> (tcl_args& arg, tcl_object*& into){
	arg.set_conversion_type("tcl_object");
	const char* t;
	arg.const_string_read(t);
	if(!t){
		into=0;
	} else {
		into = getCpptclObjectByName(arg,t);
		if(into) {
			arg.parsed_so_far << t << " ";
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}
