/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "CppTclExtra.h"
 *								   created:		1/18/95	{6:13:56 pm}
 *								   last	update:	9/12/96 {2:19:27 pm}
 *	 Author:  Vince	Darley 
 *	 E-mail:  vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 		Basic definitions and typedefs.
 * 
 * ###################################################################
 */

#ifndef _EvoX_CppTclExtra_
#define _EvoX_CppTclExtra_

#define DEBUG_PRINT
/* #define NDEBUG */

#include "CppTcl.h"

// not really used right now
typedef short object_list;
typedef short object_text_id;
const short empty_object_list = 0;

class cpx_base;
	class cpx_with_info;
	class cpx_object;

class cpx_error;

class info_base;
	class info_event;
	class info_socket;
	class info_gatherer;
	class info_source;

//@Section: CppTclExtra library
//@Man: Simple macros and typedefs
//@{
///
/** 
 * Used	just to	simplify matters for 
 * descendants of the base classes!
 * - pass one parameter, not three.
 */
struct cpx_constructor_info  {
	///
	class tcl_stream& interp;
	///
	tcl_args& args;
	///
	class cpx_with_info* container;
	///
	cpx_constructor_info(tcl_stream&, tcl_args&, cpx_with_info*);
	///
	~cpx_constructor_info(void);
};
/// an abbreviation
typedef cpx_constructor_info eci;  
/// Typedef for 'make_new' functions for cpptclextra objects
typedef class tcl_object* (*cpx_object_fn) (eci*);

/// Simplified cast required for 'info_source_fn' constructors
#define cpxR(a) (a (cpx_with_info::*)(void))
/// Simplified cast required for 'info_source_fn' constructors
#define cpxW(a) (void (cpx_with_info::*)(a))
/// Simplified cast required for 'info_source_ref_fn' constructors
#define cpxRW(a) (a& (cpx_with_info::*)(void))
								 
/// Declare a new cpptclextra object type
int declare_cpx_object(struct tcl_stream& interp, const char* tcl_command, 
						cpx_object_fn func, const char* type, 
						const char* parents, const char* short_name=0, 
						short num_of_parents=1);


///
struct cpx_error  {
	/// Error return for cpx
	typedef enum error_type  { OK=0, WARNING, ERROR, BIG_PROBLEM } error_type;

	///
	error_type error;
	///
	char* problem;
	///
	char* more_detail;

	///
	operator error_type () { return error;}
	///
	operator int () { return (int) error;}
	///
	cpx_error(error_type e);
	///
	cpx_error(error_type e, char* problem, char *more_detail=0);	
};

//@Man: Events and sockets
//@{
/** 
 * Types of	pointer	to member functions
 * for events and sockets.
 */
///
typedef void (cpx_with_info::*event_fn)(void);
///
typedef void (cpx_with_info::*socket_fn) (cpx_with_info*);
//@}

/// Used for turning archival on or off.
typedef enum archive_type { ARCHIVE=0, ON, OFF } archive_type;


//@}

typedef short object_text_list;

#ifdef __MWERKS__
#pragma cpp_extensions on
#endif


const double Pi = 3.14159265358979323846264338327950298;

void time_consuming_operation(void);

#endif
