/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "aaa_cpptclextra.h"
 *									  created: 22/6/96 {5:36:49	pm}	
 *								  last update: 22/6/96 {5:37:15 pm}	pm}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 * ###################################################################
 */

//@Man: CppTclExtra library
//@Type: CHAPTER
/**
It's often useful to have class members easily accessible from Tcl. This 
library builds upon CppTcl to give the user a very simple means for that 
feature together with the capability of attaching names to the variables so 
they may be accessed simply in Tcl.

An object can be queried for all member variables it makes available to Tcl 
(using the `object getContents' command), they may be configured together 
or individually (using a command like: `object configure -size 5 -colour 
red -length 7.135' ), and they may even be accessed directly via 
`object:size'. To gain access to all these features the user need only 
inherit from `\verb\evox_with_info\'. 

It is even possible to have Tcl variables connected to a pair of read and 
write member functions of your \CC object such that no real \CC variable 
exists for the corresponding Tcl variable!

e.g. `object:A setValue 5' calls object::setA(5) and `object:A getValue' 
calls object::getA(), all completely transparently.  To set a variable, any 
of the following syntax's is acceptable: `object configure -A 5', 
`object:A setValue 5', `object:A = 5', `object:A set 5'.  Currently the 
pure Tcl syntax `set object:A 5' is not supported.  To extract the value 
of a variable, either `object:A getValue' or `object:A get' are 
acceptable.  Again the pure Tcl variations `\$ object:A' and `set 
object:A' are not supported.

Finally CppTclExtra provides a simple container class framework, so that 
not only are class members `inside' their object, but entire objects may be 
placed inside one another.  Behind the scenes in the CppTclExtra library 
are a number of powerful features which come into their own in EvoX's data 
extraction and graphing capabilities.  Loosely speaking classes may contain 
any number of `sockets' and `events', which can be connected together 
during runtime so that classes may trigger each other to perform certain 
actions.  These are used to full effect by the EvoXBaseClasses library.  
This library may be dynamically loaded if your environment supports it, and 
adds one new command `evoxControl' to the Tcl interpreter.  This is an 
object which contains information about the \CC object hierarchy, and is 
the object with which new evox classes must be registered in \CC.
*/
