#ifdef DEFINE_TEMPLATES

#include "cpx_args.h"
#include "CppTclExtra.h"
#include "object_control.h"

template <class T> 
tcl_args& cpx_args_read(tcl_args& arg, T*& into, const char*);

#ifdef __MWERKS__
template <class T> tcl_args& operator >> (tcl_args& arg, T*& t){
	return cpx_args_read(arg, t, T::_type);
}
#endif

template <class T>
tcl_args& cpx_args_read(tcl_args& arg, T*& into, const char* type){
	arg.set_conversion_type(type);
	const char* t;
	arg.const_string_read(t);
	if(!t){
		into = 0;
	} else {
		into = ckcast(getCpxBaseByName(arg,t),T);
		if(into) {
			arg.parsed_so_far << t << " ";
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}

#endif
