/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "cpx_base.h"
 *								   created:		1/8/95 {11:30:11 pm}
 *								   last	update:	21/5/96 {1:15:41 am}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: This file contains	everything the programmer will
 *				   need	to #include	in new classes.	Not	true right
 *				   now,	but	eventually there will be such a	file.
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/8/95	 VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_cpx_base_
#define _EvoX_cpx_base_

#include <iostream.h>

#include "CppTclExtra.h"
#include "list.h"
#include "tcl_object.h"
#include "tcl_stream.h"
#include "basic_utils.h"
#include "cpx_args.h"
#include "cpx_with_type.h"
#include "cpptcl_type.h"

//@Section: CppTclExtra library
///
class cpx_base: public tcl_object, virtual public cpx_with_type {
/* 
 * Input and output	streams	for	all	objects
 * descended from here,	implemented	via	the
 * read_from_stream	and	write_to_stream
 * functions. These are primarily used for
 * argument parsing purposes, and hence only
 * apply to object which have a text representation.
 * (info_observables and info_files for example)
 */
  friend ostream& operator<< (ostream& o, cpx_base& me);
  friend istream& operator>> (istream& i, cpx_base& me);
  friend class cpx_simulation; // for archive_file
  friend class cpx_with_info;

  public:
	
//@Man: Archival, Status and Errors
//@{
/** 
 * Used	to write output	to an archive file,
 * a status	window or an error window. The
 * calls get funnelled up until	they are
 * claimed by an cpx_simulation which handles
 * them. I see no reason for the user to over-ride
 * these.
 */
	///
	ostream& archive(archive_type a=ARCHIVE) const;
	///
	ostream& status(short n) const;
	///
	ostream& error(short n) const;
//@}

	///
    virtual void find_matches_with(const list<const char*>&,
    							   socket_fn, cpx_with_info*) const{ return;}
	///
    short matches_with(const list<const char*>& l) const;
		
	//@Man: Run-Time Type Identification
	//@{
	/** 
	 * '_type' is a	short descriptive name for this	class
	 * 'type()'	is virtual and returns the _type of	the
	 * actual object. These are very important - used for
	 * CppTclExtra's built-in version of RTTI.
	 */
	///
	static const char* _type;
	///
	virtual cpx_type type(void) const=0;
	///
    virtual bool can_add(const char* t) const=0;
	//@}
	
	/// Returns whether the object contains something with this name.
	virtual const cpx_base* does_contain(const char* /* thing */) const;

//@Man: Contents checking
//@{
/** 
 * These 2 should be pure virtual, but I don't
 * know	if I want them any more. They are currently unimplemented.
 */
	///
	virtual object_text_list may_contain(void) const; 
	///
	virtual object_text_list requires_to_contain(void) const;
//@}

/* 
 * Obviously moves me to another object. Have to decide
 * how much	checking this should do.
 */
	//virtual cpx_error move_to(cpx_object* new_container);
/* 
 * Should be pure virtual. I'm not quite sure
 * what	it's for any more
 */
	virtual void draw(void); 
		
	///
/** 
 * Am I	ready to run a simulation?
 * I'm ready <==> I could run, and all
 * my contents are ready too.
 */
	virtual bool ready(void) const ; // pure virtual

	///
/** 
 * This	is virtual and is over-ridden for specific
 * commands	applicable to my main sub-classes
 */
	int parse_tcl_command(tcl_args& arg);

	/// Copy constructor, down to a specific depth of contents
	cpx_base(cpx_base&, short depth =0);
		
	/// Normal constructor
/** 
 * this	constructor	is the normal one, used	to create
 * objects to take part	in cpx	simulations
 */
	cpx_base(tcl_stream& i, const char*);
		
	/// destroys	my contents, and then myself
	virtual ~cpx_base(void);

	///
	cpx_error add_some_object(cpx_base*);
	///
	cpx_error remove_some_object(cpx_base*);
	///
	virtual	cpx_error add_info(info_base*)=0;
	///
	virtual	cpx_error remove_info(info_base*)=0;
	///
	virtual	cpx_error add_object(cpx_object*)=0;
	///
	virtual	cpx_error remove_object(cpx_object*)=0;
	
  protected:
    
    // Used by tcl/tk ??
	///
    void ive_changed(void);

//@Man: Input/Output
//@{
/** 
 * As mentioned	above, these are for input/output.
 * Perhaps to record an	objects	state, but I'm not
 * really sure yet!
 */
	///
    virtual ostream& write_to_stream(ostream& o);
	///
    virtual istream& read_from_stream(istream& i);
//@}
		
};

//@Section: CppTclExtra library
///
/** 
 * getCpxBaseByName is a utility function	that returns an 'cpx_base*' 
 * given the name of a tcl command (or NULL	of no such command exists).
 */
cpx_base* getCpxBaseByName(tcl_stream& interp, const char* name);

#endif // cpx_base.h
