/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpx_object.h"
 * 		     					   created:		1/21/95	{7:37:45 pm}
 *   							   last	update:	25/6/96 {11:52:39 pm}
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *  Description: General object. Not too well commented yet.
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	26/2/96	 VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_cpx_obj_
#define _EvoX_cpx_obj_

#include "cpx_with_run.h"
#include "cpx_with_container.icc"

//@Section: CppTclExtra library
///
class cpx_object: public cpx_with_run, public cpx_with_container {
/* I'll sort out which of these I really need later */
	friend class object_control;
	friend class info_base;
	friend class cpx_class;
	
  public:

  protected:
	
	/* Not sure what they're for yet */
	///
	ostream& write_to_stream(ostream& o);
	///
    istream& read_from_stream(istream& i);
	///
	const cpx_base* cast_to_base(void) const { return this;}
	///
	virtual void archive_creation(void);
	    
  public:
	///
	ostream& archive(archive_type a=ARCHIVE) const {
		return cpx_base::archive(a);
	}
	///
    cpx_object* is_object(void) const { return (cpx_object*) this;}

	///
    static const char* _type;	// a descriptive type name for my class
    //cpx_type type(void) const { return cpx_base::type();}
    
	///
    int parse_tcl_command(tcl_args& arg);
    
    // this function is currently de-implemented
    // (other things were changed, and I no longer use it)
	///
    cpx_error request_event(info_socket*, info_event*);


/* Currently not implemented or used!! */
	///
    virtual cpx_error make_graph_of_contents(void);
	///
    virtual cpx_error make_inspector(void);
    
/* 
 * construction	and	destruction
 */
	///
    cpx_object(eci *); 
	///
    ~cpx_object(void);

  public:
    // are we capable of containing this type; see fn below
	///
    bool can_add(const char*) const;
/* 
 * Default is to accept	graphs and inspectors but reject others.
 * This	is a virtual function and the user should over-ride, but
 * then	inherit. In particular no object should accept any
 * information dropped on it (you must drop on a piece of info).
 * This is no longer quite true: for instance inspector objects
 * accept information, which they attach to themselves.
 */
	///
    bool can_add(cpx_base* o) const { return can_add(o->type());}
		
	///
	const cpx_with_info* has_container(void) const { return container;}
	///
	const cpx_with_info* with_info(void) const { return this;}

};


#endif

