/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpx_with_container.h"
 *									  created: 20/6/95 {5:57:10	pm}	
 *								  last update: 21/5/96 {1:32:42 am} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	20/6/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_cpx_with_container_
#define _EvoX_cpx_with_container_

#include "CppTclExtra.h"
#include <iostream.h>
#include "cpx_with_type.h"
class cpx_type;

//@Section: CppTclExtra library
///
class cpx_with_container: virtual public cpx_with_type {
  public:
	/// 
	class cpx_with_info* container;
		
	/// 
	/** 
	 * Note	it would seem convenient to	put	myself in my container
	 * right now, with the following:
	 *	 if(container)
	 *		 container->add_object(this);
	 * However,	as I'm not yet a complete object, that would cause
	 * great problems. Hence whoever created me	has	to take	care of
	 * that. Fortunately that's	always a tcl_class,	so that	code is
	 * fixed in	one	place. 
	 *	   
	 * Not quite true, because we can now be created elsewhere.	E.g. a
	 * topology	may	wish to	create a few thousand objects! However,	the
	 * above sentiment still holds:	the	creator	must deal with this
	 */
	cpx_with_container(cpx_with_info* o):container(o) {}
	
	
	///
	virtual ~cpx_with_container(void);
	
	///
	virtual cpx_error move_to(cpx_object* new_container);
	///
	virtual ostream& archive(archive_type a=ARCHIVE) const=0;
	//inline cpx_type type(void) const;
	
	///
	virtual const class cpx_with_info* with_info(void) const=0;
	///
	virtual const class cpx_base* cast_to_base(void) const=0;
	///
	virtual class cpx_object* is_object(void) const { return 0;}
	///
	virtual class info_base* is_info(void) const { return 0;}

  protected:
	///
	/** 
	 * Removes myself from my container if I have one.
	 */
	void destroy_so_remove_me(void);
		
	///
	/** 
	 * This	is similar,	but	slightly different to the normal parse
	 * commands	in that	it can't call further up the hierarchy,	so
	 * just	returns.
	 */   
	int parse_tcl_command(bool& used, tcl_args& arg);
};


#endif
