/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_base.h"
 *								   created:		1/24/95	{7:21:25 pm}
 *								   last	update:	28/5/96 {8:28:06 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/24/95	  VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_base_
#define _EvoX_info_base_

#include "cpx_base.h"

typedef class info_source (cpx_with_info::*quick_ref);

//@Section: CppTclExtra library
///
class s_info_base  {
  public:
	///
    s_info_base(const char* name):_name(name) {};
    
	///
  	const char* _name;
   ~s_info_base(void){};
};

#include "cpx_with_container.icc"

//@Section: CppTclExtra library
///
class info_base : public cpx_base, public cpx_with_container {
  public:
	///
	info_base(const char* tcl_name, cpx_with_info* container); 
   ~info_base(void);
	///
	info_base(info_base&); // copy myself - perhaps not necessary

	///
	static const char* _type;
	///
	const char* name(void) const;

	///
	object_text_list may_contain(void) const { return empty_object_list;}
	///
	const cpx_base* does_contain(const char* /* thing */) const { return 0;}
	///
	object_text_list requires_to_contain(void) const { return empty_object_list;}
	///
    virtual cpx_error add_info(info_base*)=0;
	///
    virtual cpx_error remove_info(info_base*)=0;
	///
    info_base* is_info(void) const { return (info_base*) this;}
	///
	int parse_tcl_command(tcl_args& arg);
    
  protected:
	///
    cpx_error add_object(class cpx_object*) {return cpx_error::ERROR;}
	///
    cpx_error remove_object(class cpx_object*) {return cpx_error::ERROR;}

	///
	const cpx_base* cast_to_base(void) const { return this;}
	///
	ostream& archive(archive_type a=ARCHIVE) const {
		return cpx_base::archive(a);
	}
	///
	const s_info_base* s_me;
	///
	void find_static_part(const char* n);
	///
	virtual s_info_base* new_static(const char* n)=0;
	
	///
	const cpx_with_info* has_container(void) const { 
		return container;
	}
	
	///
	const class cpx_with_info* with_info(void) const { return 0;}

	///
	ostream& write_to_stream(ostream& o);
	///
	istream& read_from_stream(istream& i);
  private:
	///
    static const char* prepend_plus(cpx_with_info*, const char*);
};


#endif
