/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_event.h"
 *								   created:		1/24/95	{7:14:18 pm}
 *								   last	update:	20/5/96 {4:55:08 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/24/95	  VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_event_
#define _EvoX_info_event_

#include "info_base.h"

/* 
 * You create an event,	and	store a	pointer	to the event.
 * All the event function has to do	is call	the	trigger	function
 * of that event pointer. Cpptclextra handles the rest.
 */

class info_socket;

//@Section: CppTclExtra library
///
class info_triggerer: public info_base {
    friend class info_socket;
  public:
	///
	static const char* _type;
	///
    bool has_requests(void) const;
	///
    bool can_add(const char* t) const;
    
	///
    void trigger(void);
	///
    void trigger(class cpx_with_info*);
	///
    cpx_error add_info(info_base*); // calls register if of correct type
	///
    cpx_error remove_info(info_base*); // calls deregister if of correct type

	///
    info_triggerer(const char* tcl_name, cpx_with_info* container);
	///
    ~info_triggerer(void);
    
  protected:
	///
    int parse_tcl_command(tcl_args& arg);
    
  private:
	///
    cpx_error register_socket(info_socket*);
	///
    cpx_error deregister_socket(info_socket*);
	///
    list<info_socket*> requests;
};

//@Section: CppTclExtra library
///
class info_event: public info_triggerer   {
	///
	friend class info_socket;
  public:
	///
	static const char* _type;
	///
    cpx_type type(void) const { return _type;};
    
	///
    info_event(const char* tcl_name, cpx_with_info* container);
	///
    ~info_event(void);
    
  protected:
	///
    s_info_base* new_static(const char* n);
	///
    int parse_tcl_command(tcl_args& arg);
};

//@Section: CppTclExtra library
///
class s_info_event: public s_info_base  {
  public:
	///
	s_info_event(const char* name)
	///
	:s_info_base(name) {};
		
};

#endif
