/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_gatherer.h"
 *								   created:		1/24/95	{7:23:27 pm}
 *								   last	update:	20/5/96 {4:54:56 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/24/95	  VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_gatherer_
#define _EvoX_info_gatherer_

#include "info_base.h"
#include "info_source.h"

//@Section: CppTclExtra library
///
class s_info_gatherer: public s_info_base  {
  public:
	///
  	s_info_gatherer(const char* name):s_info_base(name) {};
};


//@Section: CppTclExtra library
///
class info_gatherer: public info_base  {
  public:
	///
    info_gatherer(const char* tcl_name, cpx_with_info* container);
	///
    cpx_type type(void) const { return _type;};
	///
    static const char* _type;
	///
    bool ready(void) const ;
	///
    void use_object(const cpx_object*);

  protected:
	///
    s_info_base* new_static(const char* n);
	///
    int parse_tcl_command(tcl_args& arg);
	///
    const cpx_with_info* temp;
	///
    short quick_lookup;
	///
    void finish_adding(class info_observable* s);
	///
    void finish_removing(class info_observable* s);
    
	///
    bool scaled;
	///
    const char *_source_name;
	///
    virtual class info_observable* my_source(void) const=0;
    
	///
    quick_ref quick_ref_source;
	///
    const char* quick_ref_type;
};

//@Section: CppTclExtra library
///
class info_src_gatherer : public info_gatherer {
  public:
	///
	#ifdef __GNUC__
	// gcc needs this for some weird reason, yet I don't use it
	// anywhere.  To be resolved....
	///
    info_src_gatherer(const info_src_gatherer&):info_gatherer(0,0) {}
	///
	#endif
	///
    info_src_gatherer(const char* tcl_name, cpx_with_info* container)
		:info_gatherer(tcl_name,container),source(0){}
	///
    cpx_error add_info(info_base* obj);
	///
    cpx_error remove_info(info_base* obj);
	///
    bool can_add(const char* t) const;
    
  protected:
	///
	class info_source* source;
	///
    class info_observable* my_source(void) const { return source;}
  private:
};

template <class T>
//@Section: CppTclExtra library
///
class info_gatherer_ :public info_src_gatherer  {
  public:
	///
    info_gatherer_(const char* tcl_name, cpx_with_info* container);
	///
    operator T () const;// should be inlined
    
	///
    info_gatherer_<T>& operator () (const cpx_with_info* obj);
	///
    T minimum(void);
	///
    T maximum(void);

  protected:
	///
    ostream& write_to_stream(ostream& o);
	///
    int parse_tcl_command(tcl_args& arg);
  private:
	///
    T scale_min, scale_max;
	///
    T clip_min, clip_max;
};


#endif
