/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_socket.h"
 *								   created:		1/24/95	{7:17:34 pm}
 *								   last	update:	20/5/96 {4:54:41 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/24/95	  VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_socket_
#define _EvoX_info_socket_

#include "info_event.h"

// You create a call-in and cpx handles everything else

//@Section: CppTclExtra library
///

class s_info_socket: public s_info_base   {
  public:
	///
    s_info_socket(const char* name):s_info_base(name) {}
    
	///
    socket_fn socket;
};

//@Section: CppTclExtra library
///
class info_socket: public info_triggerer {
  friend class info_triggerer;
  public:
	///
    info_socket(const char* tcl_name, cpx_with_info* container, socket_fn);
	///
    ~info_socket(void);
	///
    void call(cpx_with_info* obj);
	///
    static const char* _type;
	///
    cpx_type type(void) const{ return _type;};
	///
    bool can_add(const char* t) const;
	///
    bool ready(void) const ;
	///
    cpx_error add_info(info_base*); // calls register if of correct type
	///
    cpx_error remove_info(info_base*); // calls deregister if of correct type	

  protected:
	///
    s_info_base* new_static(const char* n);
	///
    int parse_tcl_command(tcl_args& arg);
	///
    cpx_error register_event(info_triggerer*);
	///
    cpx_error deregister_event(info_triggerer*);

  private:
	///
    void deregister_myself(void);
	///
    list<info_triggerer*> requestees;
};




#endif
