/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_source.h"
 *								   created:		1/24/95	{6:47:10 pm}
 *								   last	update:	20/5/96 {4:54:32 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail:  vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/24/95	 VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_source_
#define _EvoX_info_source_

#include "info_observable.h"
#include "info_pretender.h"
#include "info_limit.h"

//@Section: CppTclExtra library
///

template <class T>
class s_info_source_: public s_info_source {
  public:
	///
    s_info_source_(const char* name):s_info_source(name),_min(0),_max(0) {}
	///
    limit_<T>* _min;
	///
    limit_<T>* _max;
};


//@Section: CppTclExtra library
///
class info_source : public info_observable, virtual public info_castable {
  public:
    #ifdef __GNUC__
	/// this seems to be necessary to avoid link errors
    info_source(const info_source& ):info_observable(0,0) {}
    #endif
	///
	~info_source(){}
	
	///
    static const char* _type;
	///
	cpx_type type(void) const;
	///
    info_source(const char* tcl_name, cpx_with_info* container);
	///
	virtual void make_info_gatherer(cpx_with_info*)=0;
    
	///
    virtual bool scale(void)=0; 
	///
    virtual bool scale(short&,short&)=0;
	///
    virtual bool scale(float&,float&)=0;
	///
    virtual void minmax(short&,short&)const=0;
	///
    virtual void minmax(float&,float&)const=0;
	///
    virtual void minmax(char&,char&)const=0;
	///
    virtual void minmax(double&,double&)const=0;
	///
    virtual void minmax(long&,long&)const=0;
	///
    virtual void minmax(bool&,bool&)const=0;
	///
    virtual void hasminmax(bool& mn,bool& mx) const=0;
	

	///
	virtual	void get(short&)=0;	// what	do these all do?
	///
	virtual	void get(short&,short,short)=0;
	///
	virtual	void get(long&)=0;
	///
	virtual	void get(long&,long,long)=0;
	///
	virtual	void get(float&)=0;
	///
	virtual	void get(float&,float,float)=0;
	///
	virtual	void get(double&)=0;
	///
	virtual	void get(double&,double,double)=0;
	///
	virtual	void get(bool&)=0;
	///
	virtual	void get(bool&,bool,bool)=0;
	///
	virtual	void get(char&)=0;
	///
	virtual	void get(char&,char,char)=0;

  protected:
	///
    int parse_tcl_command(tcl_args& arg);
	///
    virtual bool is_itemised(void) const{ return false;}
	///
    virtual const char* items(void) const { return 0;}
  private:
};


#endif

