/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_adjust_var.h"
 *									  created: 6/11/95 {2:45:09	pm}	
 *								  last update: 20/5/96 {4:54:11 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	6/11/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_source_adjust_var_
#define _EvoX_info_source_adjust_var_

#include "info_source_var.h"

/* This class is for variables which when altered need to */
/* call some function to alert to this fact. In particular */
/* it is used by topologies to alert for size changes. */

//@Section: CppTclExtra library
///

template <class T>
class info_source_adjust_var : public info_source_var<T> {
  protected:
	///
	void adjust(cpx_with_info* o) {
		info_adjust_fn i = ((s_info_source_var<T>*) s_me)->adjust_fn;
		if(i){ 
			(o->*i)();
		}
	}
  
  public:
	///
    info_source_adjust_var(const char* tcl_name, cpx_with_info* container, 
					quick_ref ref=0, info_adjust_fn adjust=0);
	///
	inline T operator+= (T t) { var_t += t; adjust(container); return var_t;}
	///
	inline T operator/= (T t) { var_t /= t; adjust(container); return var_t;}
	///
	inline T operator*= (T t) { var_t *= t; adjust(container); return var_t;}
	///
	inline T operator-= (T t) { var_t -= t; adjust(container); return var_t;}
	///
    inline T operator++ () { var_t++; adjust(container); return var_t;}
	///
    inline T operator-- () { var_t--; adjust(container); return var_t;}
	///
    const info_source_t<T>& operator = (const T& t)  { 
    	var_t = t; adjust(container); return *this;
	///
    }
};



#endif
