/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_bool.h"
 *									  created: 7/26/95 {9:40:25	PM}	
 *								  last update: 25/10/96 {6:28:41 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	7/26/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_source_bool_
#define _EvoX_info_source_bool_

#include "info_source.h"

//@Section: CppTclExtra library
///

class info_source_bool : public info_source, public info_pretender<bool> {
  private:
	///
    bool p_t;  	

  public:
	///
    info_source_bool(const char* tcl_name, cpx_with_info* container, 
    				 quick_ref ref=0);
    ///
	void conversion_error(tcl_args& arg);
	///
    operator bool () const { return p_t;}
	///
	void make_info_gatherer(cpx_with_info*);
#ifdef __MWERKS__
	///
	operator && (int a) const { return (int) p_t && a;}
	//operator ^= (bool a) { p_t = (bool) ((int) p_t ^ (int) a); return p_t;}
	///
	operator int () const { return (p_t==true);}
    /*
	///
    operator == (int a) const { return ((int) p_t==a);}
	///
    operator != (int a) const { return ((int) p_t!=a);}
	///
    */
#endif
	///
	const bool& operator = (const bool& tt)  { return p_t = tt;}
    static const char* _type;
    cpx_type type(void) const {return _type;}
    
  protected:
	///
	ostream& write_to_stream(ostream& o);
	///
	istream& read_from_stream(istream& i);
	///
    s_info_base* new_static(const char* n);
	///
    int parse_tcl_command(tcl_args& arg);

	///
    bool scale(void){ return false;} // what do these three do now?
	///
    bool scale(short&,short&){ return false;}
	///
    bool scale(float&,float&){ return false;}
	///
    void minmax(short&,short&) const {}
	///
    void minmax(float&,float&) const {}
	///
    void minmax(long&,long&) const {}
	///
    void minmax(char&,char&) const {}
	///
    void minmax(double&,double&) const {}
	///
    void minmax(bool&,bool&) const {}

  public:
	///
    void get(short&){} // what do these all do?
	///
    void get(short&,short,short){}
	///
    void get(long&){}
	///
    void get(long&,long,long){}
	///
    void get(float&){}
	///
    void get(float&,float,float){}
	///
    void get(double&){}
	///
    void get(double&,double,double){}
	///
    void get(bool&){}
	///
    void get(bool&,bool,bool){}
	///
    void get(char&){}
	///
    void get(char&,char,char){}
	///
    void hasminmax(bool& mn,bool& mx) const;


};

#endif
