/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_fn.h"
 *									  created: 7/26/95 {9:36:23	PM}	
 *								  last update: 9/12/96 {2:33:07 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	7/26/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_source_fn_
#define _EvoX_info_source_fn_

#include "info_source_t.h"

 
//@Section: CppTclExtra library
///
template <class T>
class s_info_source_fn : public s_info_source_<T> {
  public:
	///
    s_info_source_fn(const char* name):s_info_source_<T>(name) {}
	///
    T read(cpx_with_info* o) 
    	{ return (o->*read_fn)();}
	///
    T write(cpx_with_info* o, T t)  
    	{ if(write_fn) (o->*write_fn)(t); return t;}
   							
	///
    T (cpx_with_info::*read_fn)(void);  	
	///
    void (cpx_with_info::*write_fn)(T);  	
};



//@Section: CppTclExtra library
///
template <class T>
class info_source_fn : public info_source_t<T> {
  public:
	///
    info_source_fn(const char* tcl_name,
		   	cpx_with_info* container,
		   	T (cpx_with_info::*read)(void),
		   	void (cpx_with_info::*write)(T),
		   	quick_ref ref=0);

	///
    operator T () const 
    	{ return ((s_info_source_fn<T>*)s_me)->read(container);}
	///
    const info_source_t<T>& operator = (const T& t)  
    	{ ((s_info_source_fn<T>*)s_me)->write(container,t); return *this;}
	///
    const info_source_t<T>& operator = (const info_source_fn<T>& i)  
    	{ return info_source_t<T>::operator=(i);}
    	
  protected:
	///
    s_info_base* new_static(const char* n);
};

//@Section: CppTclExtra library
///
template <class T>
class s_info_source_ref_fn : public s_info_source_<T> {
  public:
	///
    s_info_source_ref_fn(const char* name):s_info_source_<T>(name) {}
	///
    T& reffn(cpx_with_info* o) 
    	{ return (o->*ref)();}
	///
    T& (cpx_with_info::*ref)(void);  	
};

//@Section: CppTclExtra library
///
template <class T>
class info_source_ref_fn : public info_source_t<T> {
  public:
	///
    info_source_ref_fn(const char* tcl_name,
		   	cpx_with_info* container,
		   	T& (cpx_with_info::*reffn)(void),
		   	quick_ref ref=0);

	///
    operator T () const 
    	{ return ((s_info_source_ref_fn<T>*)s_me)->reffn(container);}
	///
    const info_source_t<T>& operator = (const T& t)  
    	{ ((s_info_source_ref_fn<T>*)s_me)->reffn(container)=t; return *this;}
	///
    const info_source_t<T>& operator = (const info_source_ref_fn<T>& i)  
    	{ return info_source_t<T>::operator=(i);}
    	
  protected:
	///
    s_info_base* new_static(const char* n);
};


 
#endif

 