/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_t.h"
 *									  created: 5/11/95 {2:23:12	pm}	
 *								  last update: 25/6/96 {3:55:28 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * 	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	5/11/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_source_t_
#define _EvoX_info_source_t_

#include "info_source.h"
#include "info_pretender.h"

//@Section: CppTclExtra library
///
template <class T>
class info_source_t: public info_source, public info_pretender<T>  {
//    friend void info_min(class I& min, const info_source_t<T>& i);
//    friend void info_max(class I& max, const info_source_t<T>& i);

  public:

#ifdef __GNUC__
	///
	~info_source_t(void) {}
#endif
	
	///
    info_source_t(const char* tcl_name, cpx_with_info* container)
    	:info_source(tcl_name, container) {}
    ///
    void conversion_error(tcl_args&);
    ///
	void list_items(ostream& obuf) const;
	///
    int parse_tcl_command(tcl_args& arg);
    	
	///
	bool in_range(T val);
	///
	info_source_t<T>& min(T t);
	///
	info_source_t<T>& minv(const char* mn);
	///
	info_source_t<T>& max(T t);
	///
	info_source_t<T>& maxv(const char* mx);
	///
	info_source_t<T>& itemised(const char* items);

	///
	virtual cpx_with_info* read_from_object(void) const { return container;}
	///
	void make_info_gatherer(cpx_with_info*);
	// already inherited virtually
	//virtual operator const T& () const=0;
	///
	virtual const info_source_t<T>& operator= (const T&)=0;
	///
	const info_source_t<T>& operator= (const info_source_t<T>& i){
		return operator= ((T) i); // cast source to value for assignment
	}
	
	///
	void get(short&); // what do these all do?
	///
    void get(short&,short,short);
	///
    void get(long&);
	///
    void get(long&,long,long);
	///
    void get(float&);
	///
    void get(float&,float,float);
	///
    void get(double&);
	///
    void get(double&,double,double);
	///
    void get(bool&);
	///
    void get(bool&,bool,bool);
	///
    void get(char&);
	///
    void get(char&,char,char);
	///
    void hasminmax(bool& mn,bool& mx) const;

  protected:
	///
	ostream& write_to_stream(ostream& o);
	///
	istream& read_from_stream(istream& i);
	///
    bool scale(void); // what do these three do now?
	///
    bool scale(short&,short&);
	///
    bool scale(float&,float&);
	///
    void minmax(short&,short&) const;
	///
    void minmax(float&,float&) const;
	///
    void minmax(long&,long&) const;
	///
    void minmax(char&,char&) const;
	///
    void minmax(double&,double&) const;
	///
    void minmax(bool&,bool&) const;
	///
    T minimum (void) const { return _min()->value(container);}
	///
    T maximum (void) const { return _max()->value(container);}

  protected:
	///
    bool is_itemised(void) const;
	///
    const char* items(void) const;
	///
    limit_<T>*& _min()  const { return ((s_info_source_<T>*)s_me)->_min;}
	///
    limit_<T>*& _max()  const { return ((s_info_source_<T>*)s_me)->_max;}

  public:
};


/*
template <class T, class I>
void info_get(T& var, const info_source_t<I>& i){var = (T)(I)(*i);}

template <class T, class I>
void info_min(T& min, const info_source_t<I>& i){if(i->_min()) min = (T)(I)(i->minimum());}

template <class T, class I>
void info_max(T& max, const info_source_t<I>& i){if(i->_max()) max = (T)(I)(i->maximum());}
*/

#endif
