/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_vars.h"
 *									  created: 11/5/96 {4:38:13	pm}	
 *								  last update: 9/12/96 {12:39:05 pm}	pm}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	11/5/96	 VMD 1.0 original
 * ###################################################################
 */


#ifndef _EvoX_info_source_vars_
#define _EvoX_info_source_vars_

#include "info_source_t.h"

//@Section: CppTclExtra library
///
template <class T>
class info_var  {
  public:
#ifdef __GNUC__
	///
	info_var(void);
	///
	virtual ~info_var(void);
	///
	info_var(info_var<T>&);
#else
	///
	info_var(void) {}
	///
	virtual ~info_var(void) {}
	///
	info_var(info_var<T>&) {}
#endif	
	///
	typedef T (cpx_with_info::*ireadv);

	///
	virtual T& var_ref(cpx_with_info*) const=0;
	///
	virtual ireadv var(void) const = 0;
	
};

//@Section: CppTclExtra library
///
template <class S, class T>
class info_var_t : public info_var<T>  {
	///
	typedef T S::*cvar;
  public:
	///
	info_var_t(cvar a):var_(a) {}
	///
	~info_var_t(void){}
	///
	info_var_t(const info_var_t& i):var_(i.var_) {}
	
	///
	T& var_ref(cpx_with_info* i) const { return var_ref((S*)i);}
	///
	T& var_ref(S* s) const { return s->*var_;}
	///
	typedef T (cpx_with_info::*ireadv);
	///
  	ireadv var(void) const { return (ireadv)var_;}
  	
  private:
	///
	T S::*var_;
};

//@Section: CppTclExtra library
///
template <class T>
class s_info_source_var_indirect : public s_info_source_<T> {
public:
	///
    s_info_source_var_indirect(const char* name):s_info_source_<T>(name) {}
    // The objects passed in here are not the container, but
    // the object to be read from indirectly
	///
    T& var(cpx_with_info* from) {return (from->*var_);}
    							
	///
  	T cpx_with_info::*var_;
};

//@Section: CppTclExtra library
///
template <class T>
class info_source_var_indirect : public info_source_t<T> {
  public:
	///
    info_source_var_indirect(const char* tcl_name
			    , cpx_with_info* container
			    , cpx_with_info* info_from
			    , const info_var<T>&
			    , quick_ref ref=0);
			    
	///
    operator T () const 
    	{ return ((s_info_source_var_indirect<T>*)s_me)->var(info_from);}
	///
    const info_source_t<T>& operator = (const T& t) 
    	{ ((s_info_source_var_indirect<T>*)s_me)->var(info_from) = t; return *this;}
  protected:
	///
	cpx_with_info* info_from;
	
	///
	cpx_with_info* read_from_object(void) const { return info_from;}
	///
    s_info_base* new_static(const char* n);
};

#endif
