/* -*-C++-*-
 * ############################################################################
 *	EvoX - evolution in	complex	systems							  
 *	
 *	FILE: "object_control.h"
 *										   created:	12/14/93 10:26:52 AM
 *									   last	update:	20/7/96 {6:01:26 pm}
 *	  by: Vince	Darley
 *			 E-mail: vince@das.harvard.edu
 *			   mail:   Divison of Applied Sciences,	Harvard	University
 *					Cambridge MA 02138
 * 
 *	DESCRIPTION: Mediates flow of interesting information between
 *				 the user and the different	CppTclExtra objects 
 *				 
 *	HISTORY
 *					 
 *	modified who rev reason
 *	-------- --- --- ------	
 *	12/14/93 VMD 1.0 Original
 *	1/12/94	 VMD 1.1 Created internal hierarchy	of analysis-nodes as planned
 *	16/7/94	  VMD 1.2 Now allows for multiple inheritance
 *	_/_/_
 * ############################################################################
 */

#ifndef _EvoX_object_control_
#define _EvoX_object_control_

#include "cpx_base.h"
#include "CppTclExtra.h"
#include "cpx_with_info.h"
#include "cpptcl_metaobject.h"
#include "info_source_var.h"
#include "info_file_o.h"
class object;

//@Section: CppTclExtra library
///
int declare_cpx_object(struct tcl_stream& interp, const char* tcl_command, 
							 cpx_object_fn func, const char* type, 
							 const char* parents, const char*, short num_of_parents);


//@Section: CppTclExtra library
///
/** 
 * -------------------------------------------------------------------------
 *	 
 * "object_control"	--
 *	
 *	Important control object of	which a	single instance	'cpptclControl'
 *	exists in the Tcl interpreter.	It is created automatically	by the
 *	package	init procedure.
 *		   
 * Command Summary:
 *	   
 *	   % documentObject	cpptclControl
 *	   cpptclControl addObjectType : inform	control	of a new cpx_type
 *	   cpptclControl commandFor	: the creation command for an object of	the	given type
 *	   cpptclControl getType : returns cpx_type	of this	object
 *	   cpptclControl hasDescendants	: test if this cpx_type	has	further	derived	types
 *	   cpptclControl isa : tests whether one type descends from	another
 *	   cpptclControl listAncestry :	list all ancestral types
 *	   cpptclControl listParents : list	parent types
 *	   cpptclControl listTypes : list of direct	descendants
 *	   cpptclControl rename	: changes the Tcl command name of the object
 *	
 * --Version--Author------------------Changes-------------------------------  
 *	  1.0	  <vince@das.harvard.edu> original
 * -------------------------------------------------------------------------
 */
class object_control: public cpptcl_metaobject {
  public:
	///
    friend int declare_cpx_object(struct tcl_stream& interp, const char* tcl_command, 
								 cpx_object_fn func, const char* type, 
								 const char* parents, const char*, short num_of_parents=1);

	///
    int parse_tcl_command(tcl_args& arg);
	///
	int check_command_line(cpx_object_fn func, tcl_args& arg, 
								   eci* &e, tcl_stream&);
	///
	static cpptcl_metaobject* take_over(tcl_args& arg, cpptcl_metaobject* o) {
		return new object_control(arg,o);
	}
  protected:
	///
    object_control(tcl_args&,cpptcl_metaobject*);
   ~object_control(void);

  protected:	  
    int new_object_type(tcl_stream& interp, const char* tcl_command, 
			new_object_fn func, const char* type, 
			const char* parent_name, short num_of_parents=0)
			{ return cpptcl_metaobject::new_object_type(interp, tcl_command, func, 
			  type, parent_name,num_of_parents);
			}
    int new_object_type(tcl_stream& interp, const char* type, 
			const char* parent_name, short num_of_parents=0)
			{ return cpptcl_metaobject::new_object_type(interp, 
			  type, parent_name,num_of_parents);
			}
    int new_object_type(tcl_stream& interp, object* o,
			const char* parent_name, short num_of_parents=0)
			{ return cpptcl_metaobject::new_object_type(interp, o,
			  parent_name,num_of_parents);
			}
	///
    int new_object_type(tcl_stream& interp, const char* tcl_command, 
			cpx_object_fn func, const char* type, 
			const char* parent_name, short num_of_parents=0);
    
};

#endif





