/* -*-C++-*-
 * ############################################################################
 *	EvoX - evolution in	complex	systems							  
 *	
 *	FILE: "record_keeper.h"
 *										   created:	12/14/93 10:26:52 AM
 *									   last	update:	3/11/96 {5:13:28 pm}
 *	  by: Vince	Darley
 *			 E-mail: vince@das.harvard.edu
 *			   mail:   Divison of Applied Sciences,	Harvard	University
 *					Cambridge MA 02138
 * 
 *	DESCRIPTION: Mediates flow of interesting information between
 *				 the user and the different	CppTclExtra objects 
 *				 
 *	HISTORY
 *					 
 *	modified who rev reason
 *	-------- --- --- ------	
 *	12/14/93 VMD 1.0 Original
 *	1/12/94	 VMD 1.1 Created internal hierarchy	of analysis-nodes as planned
 *	16/7/94	  VMD 1.2 Now allows for multiple inheritance
 *	_/_/_
 * ############################################################################
 */

#ifndef _EvoX_record_keeper_
#define _EvoX_record_keeper_

#include "cpx_base.h"
#include "CppTclExtra.h"
#include "cpx_with_info.h"
#include "info_source_var.h"
#include "info_file_o.h"

//@Section: CppTclExtra library
///
class tcl_ostream :public ostrstream {
	/// Dump the stuff to the correct stderr/out
    friend ostream& endline(ostream& outs);

  private:
    /// tcl interpreter 
    Tcl_Interp* interp_;

	/// we use this command for output
	const char* output_command;
	
  public:
	/// Add our command to the beginning of the stream
  	void add_output_command(void) {
  		(*this) << output_command;
  	}
  
    /// Constructor
	tcl_ostream(Tcl_Interp* interp, const char* command) 
		:interp_(interp), output_command(command) {
		if(output_command)
			add_output_command();
	}

	~tcl_ostream(void) {}		
	
};

//@Section: CppTclExtra library
///
/** 
 * -------------------------------------------------------------------------
 *	 
 * "record_keeper"	--
 *	
 *	Important control object of	which a	single instance	'cpptclControl'
 *	exists in the Tcl interpreter.	It is created automatically	by the
 *	package	init procedure.
 *		   
 * Command Summary:
 *	   
 *	   % documentObject	cpptclControl
 *	
 * --Version--Author------------------Changes-------------------------------  
 *	  1.0	  <vince@das.harvard.edu> original
 * -------------------------------------------------------------------------
 */
class record_keeper: public cpx_with_info {
  public:
  	friend cpx_base;
  
  public:
	///
    record_keeper(tcl_args&);
   ~record_keeper(void);

  protected:	  
	///
    ostream& status(short) const;
	///
    ostream& error(short) const;
	///
    ostream& archive(archive_type=ARCHIVE) const;

	///
    mutable info_file_o archive_file;
	///
    info_source_var<short> error_level;
	///
    info_source_var<short> status_level;
    
  private:
	///
  	ostream& null(void) const;
	///
	mutable tcl_ostream tcl_cout;
	///
	mutable tcl_ostream tcl_cerr;
	///
	mutable tcl_ostream tcl_null;
	
};

extern record_keeper* _cpx_record_keeper;

#endif





