/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpx_args.cc"
 *									  created: 19/4/96 {7:36:13	pm}	
 *								  last update: 22/7/96 {3:32:02 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */


#include "cpx_args.h"
#include "CppTclExtra.h"
#include "object_control.h"


tcl_args& operator>> (tcl_args& arg, cpx_base*& into){
	arg.set_conversion_type("cpx_base");
	const char* t;
	arg.const_string_read(t);
	if(!t){
		into=0;
	} else {
		into = getCpxBaseByName(arg,t);
		if(into) {
			arg.parsed_so_far << t << " ";
		} else {
			arg.signal_error(tcl_args::Conversion);
		}
	}
	arg.read_done();
	return arg;
}


tcl_args& operator>> (tcl_args& arg, info_file& into){
	arg.set_conversion_type("file_name");
	const char* t;
	arg.const_string_read(t);
	if(!t){
		(void)into;
	} else {
		// We don't use 'arg >> into' because that won't work
		// if the filename contains spaces.  I don't know how
		// to fix that in general.  It is hard becuase arg >> into 
		// is handled by code which just expects a generic 
		// istream, not a tcl_args.
		if(arg.completing()) {
			if(arg.empty()) {
				// we should try and complete the file
				// CODE TO BE WRITTEN (or rather grabbed from somewhere!)
			} else {
				arg.parsed_so_far << t << " ";
				// we just continue
			}
		} else {
			if(into.set_file(t,false)) {
				arg.parsed_so_far << t << " ";
			} else {
				arg.signal_error(tcl_args::Conversion);
			}
		}
	}
	arg.read_done();
	return arg;
}

// to do: add better error message to this.
tcl_args& operator>> (tcl_args& arg, info_observable& into){
	arg.set_conversion_type("info_observable");
	if(arg.is_optional_arg() && !arg.args_left()) {
		arg.pretend_read_from_me();
	} else {
		if(arg.completing()) {
			if(arg.args_left() == 1) {
				if(arg == "unimplemented completion")
					DO_NOTHING;
				arg.no_match();
				// we should try and complete if possible
			} else {
				// to add it to the parsed list
				arg >> arg.tmp_chars;
				// we just continue
			}
		} else {
			arg.check_read() >> into;
			if(!arg.arg_read_ok()) {
				into.conversion_error(arg);
			}
			arg.check_after();
			arg.parsed_so_far << into << " ";
			arg.read_done();
		}
	}
	return arg;
}

