/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "cpx_base.cc"
 *								   created:		1/8/95 {11:39:35 pm}
 *								   last	update:	24/7/96 {12:38:19 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpx_base.icc"
#include "info_base.h"
#include "cpx_object.h"
#include "util.h"
#include <string.h>
#include <strstream.h>
#include "record_keeper.h"
#include "cpptcl_type.h"
#include "cpptcl_metaobject.h"

extern record_keeper* _cpx_record_keeper;
const char* cpx_base::_type = "Base";

ostream& cpx_base::archive(archive_type a)	const {
	return _cpx_record_keeper->archive(a);
}

ostream& cpx_base::status(short n)	const{
	return _cpx_record_keeper->status(n);
}

ostream& cpx_base::error(short	n) const{
	return _cpx_record_keeper->error(n);
}

ostream& operator<< (ostream& o, cpx_base& me) {
    return me.write_to_stream(o);
}

istream& operator>> (istream& i, cpx_base& me) {
    return me.read_from_stream(i);
}

ostream& cpx_base::write_to_stream(ostream& o) {
    return o << get_tcl_command() << " ";
}

istream& cpx_base::read_from_stream(istream& i) {
    return i;
}

object_text_list cpx_base::may_contain(void) const{
    return 0;
}

const cpx_base* cpx_base::does_contain(const char* thing) const{
    return (strcmp(thing,get_tcl_command()) ? (cpx_base*)0 : this);
}

object_text_list cpx_base::requires_to_contain(void) const {
    return 0;
}

short cpx_base::matches_with(const list<const char*>& l) const {
    short count = 1;
    for(list_pos<const char*> s(l);s; ++s, count++){
		if(s.item() == get_tcl_command())
		    return count;
    }
    return 0;
}

void cpx_base::draw(void) {
}

/* 
 * am I	ready to run a simulation?
 */
bool cpx_base::ready(void) const  {
    return true;
}

cpx_error cpx_base::add_some_object(cpx_base* e)	{
	if(info_base *i	= ckcast(e,info_base))	{
		return add_info(i);
	} else 
		if(cpx_object	*o = ckcast(e,cpx_object))	{
			return add_object(o);
		}
	return cpx_error::ERROR;
}

cpx_error cpx_base::remove_some_object(cpx_base*	e) {
	if(info_base *i	= ckcast(e,info_base))	{
		return remove_info(i);
	} else 
		if(cpx_object	*o = ckcast(e,cpx_object))	{
			return remove_object(o);
		}
	return cpx_error::ERROR;
}

void cpx_base::ive_changed(void){
}

cpx_base::cpx_base(cpx_base& e, short /* depth */)
    :tcl_object(e) {
}

cpx_base::cpx_base(tcl_stream& i, const char* n)
    :tcl_object(i,n) 
{
	
	//itcl_widget = 0;
}

cpx_base::~cpx_base(void){
}

//virtual
int cpx_base::parse_tcl_command(tcl_args& arg){	
    if (arg("","returns cpx_type of this object")=="getType") {
    	arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
		tcl_ << type() << result;
		return TCL_OK;
    } else if (arg("type","can this type be put inside me?")=="canAdd") {
		cpx_type ty;
		arg >> ty >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
	    if(can_add(ty)) {
			tcl_ << "1" << result;
	    } else  {
			tcl_ << "0" << result;
	    }
	    return TCL_OK;
/*    } else if (arg("")=="display") {
		// return my itcl_widget
		if(itcl_widget == 0){
			// I have no itcl instantiation
			ostrstream ostr;
			ostr << "cpxMakeAndDisplay "
			     << get_tcl_command() << " ";
			Tcl_Eval(get_interp(),ostr.str());
			return TCL_OK;
	    } else {
			ostrstream ostr;
			ostr << "cpxDisplay " << itcl_widget << endl;
			Tcl_Eval(get_interp(),ostr.str());
			return TCL_OK;
	    }
	} else if (arg("")=="getItclWidget") {
	    // return my itcl_widget
	    if(itcl_widget == 0){
		tcl_ << "" << result;
	    } else {
		tcl_ << itcl_widget << result;
	    }
	    return TCL_OK;
	} else if (arg("")=="setItclWidget") {
	    // if I have a itcl_widget name already, signal an error
	    if(itcl_widget){
		tcl_ <<  get_tcl_command() << ":I already own a widget."<< tcl_error;
		return TCL_ERROR;
	    }
	    // set my itcl_widget to the argument
	    if (argc<2){
		tcl_ <<  get_tcl_command() << ": Need a widget argument."<< tcl_error;
		return TCL_ERROR;
	    }
	    itcl_widget = mystrdup(argv[1]);
	    return TCL_OK;
		*/
	} else if (arg("","am I ready to run?")=="ready") {
		arg >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
	    if(ready()){
			tcl_ << "1" << result;
	    } else {
			tcl_ << "0" << result;
	    }
	    return TCL_OK;
/*	} else if (arg("")=="deleteItclWidget") {
	    // if I don't have a itcl_widget name already, signal an error
	    if(!itcl_widget){
		tcl_ <<  get_tcl_command() << ":I don't own a widget."<< tcl_error;
		return TCL_ERROR;
	    }
	    // bin my itcl_widget - my container has been collapsed I assume
	    delete itcl_widget;
	    itcl_widget = 0;
	    return TCL_OK;
		*/
	} else if (arg("type","am I of the given type?")=="areYou") {
		cpx_type obj;
		arg >> obj >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
	    bool answer = namecast(type(),obj);
	    tcl_ << BOOL answer << result;           	
	    return TCL_OK;
	} else if (arg("item")=="doesContain") {
		const char* ev;
		arg >> ev >> done;
		NO_EXCEPTIONS(arg,TCL_ERROR);
	    const cpx_base* ans = does_contain(ev);
	    if(ans) {
			tcl_ << ans->get_tcl_command() << result;
	    }
	    return TCL_OK;
	} else  // if we don't recognize the command, see if tcl_object does
	    return tcl_object::parse_tcl_command(arg);
}

/*
tcl_args& cpx_base::make_parser(tcl_stream& t, int argc, char* argv[], 
	                             class tcl_object*o) {
	return *(new cpx_args(t,argc,argv,o));
}	                                                        	
*/	

cpx_base* getCpxBaseByName(tcl_stream& i, const char* name){
  	Tcl_CmdInfo info;
  	if (!Tcl_GetCommandInfo(i.interpreter(), (char*) name, &info))
    	return (cpx_base*) NULL;
  	else
    	return (cpx_base*) (info.clientData);
}
