/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "cpx_class.cc"
 *								   created:		1/22/95	{11:33:30 pm}
 *								   last	update:	9/12/96 {3:45:19 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "cpx_class.h"
#include <strstream.h>
#include <string.h>
#include "object_control.h"
#include "cpx_object.h"

/* 
 * Syntax is as	follows:
 *	   
 *	   cpxTYPE	  'name' in	'container'
 *	   cpxTYPE	  '+name' in 'container'
 *	   
 * The last	option grabs the name 'container' and
 * appends '.name' for the new object's name - just
 * to save on typing.
 */

int cpx_class::parse_tcl_command(tcl_args& arg){
	if(arg("?construction arguments? ?configuration options?",
		   "make an object").match_into(arg.tmp_chars,"'name_of_new_object'")) {
		// To investigate: remove this line and let command completion
		// extend into the innards of object creation.
		if(arg.haveErr)
			return TCL_ERROR;
		arg.setName(arg.tmp_chars);

		eci* ii = 0;
		if (((object_control*)_global_cpptcl_metaobject)->check_command_line(newFunc, arg, 
																	 ii,get_tcl_stream()))
			return TCL_ERROR;
		
		if (ii ==0){
		    tcl_ <<  get_tcl_command() 
		    	 << ": No creation function is known. Check your C++ code."
		    	 << tcl_error;
		    return TCL_ERROR;
		}
		
	    // So we're all set to create the object:      		
	    if (tcl_object* obj = (*newFunc)(ii)) {
			// Now we need to add it to it's container
			if(ii->container){
				// We know it's really a 'cpx_object'.
			    cpx_object* o = (cpx_object*) obj;
			    ii->container->add_object(o);
				o->archive_creation();
				o->archive() << endl;
			}
			// now we delete the 'eci' wrapper
			delete ii;
			// if no args left
			if(!arg) {
				arg >> done;
				if(arg.haveErr) {
					// delete the object if there was an error
					delete obj;
					return TCL_ERROR;
				}
			} else {
				// if args, use them as configuration
				// if there's an error now, don't delete the object
				if(!arg.empty())
					if(obj->parse_configuration_values(arg) == TCL_ERROR)
						return TCL_ERROR;
			}
	
			// object was created. We want to return it's name
			// so we can nest creations.
			tcl_ << obj->get_tcl_command() << result;		
			return TCL_OK;
	    } else  {
	    	// We expect the constructor to return whatever error message is appropriate.
			delete ii;
			return TCL_ERROR;
	    }
	} else {
		return tcl_object::parse_tcl_command(arg);
	}	
    
}



